"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const aws_s3_deployment_1 = require("@aws-cdk/aws-s3-deployment");
const core_1 = require("@aws-cdk/core");
const cdk_deletable_bucket_1 = require("@cloudcomponents/cdk-deletable-bucket");
class WebsiteBucket extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { bucketName, removalPolicy = core_1.RemovalPolicy.RETAIN, disableUpload = false, source, websiteIndexDocument, websiteErrorDocument } = props;
        const bucket = new aws_s3_1.Bucket(this, 'WebsiteBucket', {
            bucketName,
            removalPolicy,
            websiteIndexDocument: websiteIndexDocument || 'index.html',
            websiteErrorDocument: websiteErrorDocument || 'error.html',
        });
        if (removalPolicy === core_1.RemovalPolicy.DESTROY) {
            new cdk_deletable_bucket_1.EmptyBucket(this, 'EmptyBucket', {
                bucket,
            });
        }
        const originAccessIdentity = new aws_cloudfront_1.OriginAccessIdentity(this, 'OriginAccessIdentity', {
            comment: `CloudFront OriginAccessIdentity for ${bucket.bucketName}`,
        });
        bucket.grantRead(originAccessIdentity.grantPrincipal);
        if (!disableUpload) {
            const placeHolderSource = path.join(__dirname, '..', 'website');
            new aws_s3_deployment_1.BucketDeployment(this, 'Deployment', {
                sources: [aws_s3_deployment_1.Source.asset(source || placeHolderSource)],
                destinationBucket: bucket,
                retainOnDelete: removalPolicy === core_1.RemovalPolicy.RETAIN,
            });
        }
        this.s3OriginConfig = {
            originAccessIdentity,
            s3BucketSource: bucket,
        };
    }
}
exports.WebsiteBucket = WebsiteBucket;
_a = JSII_RTTI_SYMBOL_1;
WebsiteBucket[_a] = { fqn: "@cloudcomponents/cdk-static-website.WebsiteBucket", version: "1.25.1" };
//# sourceMappingURL=data:application/json;base64,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