/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfYearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -6821236822336841037L;
    private final BasicChronology iChronology;

    BasicDayOfYearDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.dayOfYear(), durationField);
        this.iChronology = basicChronology;
    }

    public int get(long l2) {
        return this.iChronology.getDayOfYear(l2);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return this.iChronology.getDaysInYearMax();
    }

    public int getMaximumValue(long l2) {
        int n2 = this.iChronology.getYear(l2);
        return this.iChronology.getDaysInYear(n2);
    }

    public int getMaximumValue(ReadablePartial readablePartial) {
        if (readablePartial.isSupported(DateTimeFieldType.year())) {
            int n2 = readablePartial.get(DateTimeFieldType.year());
            return this.iChronology.getDaysInYear(n2);
        }
        return this.iChronology.getDaysInYearMax();
    }

    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        int n2 = readablePartial.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (readablePartial.getFieldType(i2) != DateTimeFieldType.year()) continue;
            int n3 = nArray[i2];
            return this.iChronology.getDaysInYear(n3);
        }
        return this.iChronology.getDaysInYearMax();
    }

    protected int getMaximumValueForSet(long l2, int n2) {
        int n3 = this.iChronology.getDaysInYearMax() - 1;
        return n2 > n3 || n2 < 1 ? this.getMaximumValue(l2) : n3;
    }

    public boolean isLeap(long l2) {
        return this.iChronology.isLeapDay(l2);
    }

    private Object readResolve() {
        return this.iChronology.dayOfYear();
    }
}

