# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.details_optical import DetailsOptical
from regula.documentreader.webclient.gen.models.details_rfid import DetailsRFID
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class Status(BaseModel):
    """
    Status
    """ # noqa: E501
    overall_status: SkipValidation[CheckResult] = Field(alias="overallStatus")
    optical: SkipValidation[CheckResult] = Field(alias="optical")
    portrait: SkipValidation[CheckResult] = Field(alias="portrait")
    rfid: SkipValidation[CheckResult] = Field(alias="rfid")
    stop_list: SkipValidation[CheckResult] = Field(alias="stopList")
    details_rfid: SkipValidation[Optional[DetailsRFID]] = Field(alias="detailsRFID", default=None)
    details_optical: SkipValidation[DetailsOptical] = Field(alias="detailsOptical")
    __properties: ClassVar[List[str]] = ["overallStatus", "optical", "portrait", "rfid", "stopList", "detailsRFID", "detailsOptical"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Status from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of details_rfid
        if self.details_rfid:
            _dict['detailsRFID'] = self.details_rfid.to_dict()
        # override the default output from pydantic by calling `to_dict()` of details_optical
        if self.details_optical:
            _dict['detailsOptical'] = self.details_optical.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Status from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "overallStatus": obj.get("overallStatus"),
            "optical": obj.get("optical"),
            "portrait": obj.get("portrait"),
            "rfid": obj.get("rfid"),
            "stopList": obj.get("stopList"),
            "detailsRFID": DetailsRFID.from_dict(obj["detailsRFID"]) if obj.get("detailsRFID") is not None else None,
            "detailsOptical": DetailsOptical.from_dict(obj["detailsOptical"]) if obj.get("detailsOptical") is not None else None
        })
        return _obj


