# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class RfidOrigin(BaseModel):
    """
    Location of data in RFID chip
    """ # noqa: E501
    dg: SkipValidation[int] = Field(alias="dg", description="Source data group file")
    dg_tag: SkipValidation[int] = Field(alias="dgTag", description="Index of the source record of the image with biometric information in the information data group")
    tag_entry: SkipValidation[int] = Field(alias="tagEntry", description="Index of the template in the record with biometric data")
    entry_view: SkipValidation[int] = Field(alias="entryView", description="Index of the variant of the biometric data template")
    __properties: ClassVar[List[str]] = ["dg", "dgTag", "tagEntry", "entryView"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidOrigin from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidOrigin from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dg": obj.get("dg"),
            "dgTag": obj.get("dgTag"),
            "tagEntry": obj.get("tagEntry"),
            "entryView": obj.get("entryView")
        })
        return _obj


