# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.rfid_access_control_procedure_type import RfidAccessControlProcedureType
from regula.documentreader.webclient.gen.models.rfid_error_codes import RFIDErrorCodes
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class RfidAccessControlInfo(BaseModel):
    """
    Structure is used to describe the results of a single authentication procedure or a procedure of secure data access within the context of the communication session with electronic document
    """ # noqa: E501
    type: SkipValidation[RfidAccessControlProcedureType] = Field(alias="Type")
    status: SkipValidation[RFIDErrorCodes] = Field(alias="Status")
    active_option_idx: SkipValidation[Optional[float]] = Field(alias="ActiveOptionIdx", default=None, description="Index of the active variant of the procedure")
    notifications: SkipValidation[List[int]] = Field(alias="Notifications", description="List of remarks arisen during the procedure. Can be ParsingErrorCodes or ParsingNotificationCodes enum.")
    access_control_options: SkipValidation[Optional[List[object]]] = Field(alias="AccessControlOptions", default=None, description="List of structures with are used to describe the variants of the authentication or secure data access procedure performance within the context of the communication session with electronic document")
    __properties: ClassVar[List[str]] = ["Type", "Status", "ActiveOptionIdx", "Notifications", "AccessControlOptions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidAccessControlInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidAccessControlInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "Status": obj.get("Status"),
            "ActiveOptionIdx": obj.get("ActiveOptionIdx"),
            "Notifications": obj.get("Notifications"),
            "AccessControlOptions": obj.get("AccessControlOptions")
        })
        return _obj


