# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class LivenessParams(BaseModel):
    """
    LivenessParams
    """ # noqa: E501
    check_ovi: SkipValidation[Optional[bool]] = Field(alias="checkOVI", default=None, description="This parameter is used to enable OVI check")
    check_mli: SkipValidation[Optional[bool]] = Field(alias="checkMLI", default=None, description="This parameter is used to enable MLI check")
    check_holo: SkipValidation[Optional[bool]] = Field(alias="checkHolo", default=None, description="This parameter is used to enable Hologram detection")
    check_ed: SkipValidation[Optional[bool]] = Field(alias="checkED", default=None, description="This parameter is used to enable Electronic device detection")
    check_black_and_white_copy: SkipValidation[Optional[bool]] = Field(alias="checkBlackAndWhiteCopy", default=None, description="This parameter is used to enable Black and white copy check")
    check_dynaprint: SkipValidation[Optional[bool]] = Field(alias="checkDynaprint", default=None, description="This parameter is used to enable Dynaprint check")
    check_geometry: SkipValidation[Optional[bool]] = Field(alias="checkGeometry", default=None, description="This parameter is used to enable Geometry check")
    __properties: ClassVar[List[str]] = ["checkOVI", "checkMLI", "checkHolo", "checkED", "checkBlackAndWhiteCopy", "checkDynaprint", "checkGeometry"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LivenessParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LivenessParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "checkOVI": obj.get("checkOVI"),
            "checkMLI": obj.get("checkMLI"),
            "checkHolo": obj.get("checkHolo"),
            "checkED": obj.get("checkED"),
            "checkBlackAndWhiteCopy": obj.get("checkBlackAndWhiteCopy"),
            "checkDynaprint": obj.get("checkDynaprint"),
            "checkGeometry": obj.get("checkGeometry")
        })
        return _obj


