# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class DetailsOptical(BaseModel):
    """
    Details on performed optical checks
    """ # noqa: E501
    overall_status: SkipValidation[CheckResult] = Field(alias="overallStatus")
    doc_type: SkipValidation[CheckResult] = Field(alias="docType")
    expiry: SkipValidation[CheckResult] = Field(alias="expiry")
    image_qa: SkipValidation[CheckResult] = Field(alias="imageQA")
    mrz: SkipValidation[CheckResult] = Field(alias="mrz")
    pages_count: SkipValidation[int] = Field(alias="pagesCount", description="Number of processed pages in the document")
    security: SkipValidation[CheckResult] = Field(alias="security")
    text: SkipValidation[CheckResult] = Field(alias="text")
    vds: SkipValidation[Optional[int]] = Field(alias="vds", default=None)
    __properties: ClassVar[List[str]] = ["overallStatus", "docType", "expiry", "imageQA", "mrz", "pagesCount", "security", "text", "vds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DetailsOptical from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DetailsOptical from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "overallStatus": obj.get("overallStatus"),
            "docType": obj.get("docType"),
            "expiry": obj.get("expiry"),
            "imageQA": obj.get("imageQA"),
            "mrz": obj.get("mrz"),
            "pagesCount": obj.get("pagesCount"),
            "security": obj.get("security"),
            "text": obj.get("text"),
            "vds": obj.get("vds")
        })
        return _obj


