# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class Vault(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, role: str=None, secret_engine_path: str=None, token: str=None, url: str=None):  # noqa: E501
        """Vault - a model defined in Swagger

        :param role: The role of this Vault.  # noqa: E501
        :type role: str
        :param secret_engine_path: The secret_engine_path of this Vault.  # noqa: E501
        :type secret_engine_path: str
        :param token: The token of this Vault.  # noqa: E501
        :type token: str
        :param url: The url of this Vault.  # noqa: E501
        :type url: str
        """
        self.swagger_types = {
            'role': str,
            'secret_engine_path': str,
            'token': str,
            'url': str
        }

        self.attribute_map = {
            'role': 'role',
            'secret_engine_path': 'secretEnginePath',
            'token': 'token',
            'url': 'url'
        }

        self._role = role
        self._secret_engine_path = secret_engine_path
        self._token = token
        self._url = url

    @classmethod
    def from_dict(cls, dikt) -> 'Vault':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Vault of this Vault.  # noqa: E501
        :rtype: Vault
        """
        return util.deserialize_model(dikt, cls)

    @property
    def role(self) -> str:
        """Gets the role of this Vault.

        Vault role for access to the secret engine path  # noqa: E501

        :return: The role of this Vault.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role: str):
        """Sets the role of this Vault.

        Vault role for access to the secret engine path  # noqa: E501

        :param role: The role of this Vault.
        :type role: str
        """

        self._role = role

    @property
    def secret_engine_path(self) -> str:
        """Gets the secret_engine_path of this Vault.

        Vault secret engine path where connection will be stored  # noqa: E501

        :return: The secret_engine_path of this Vault.
        :rtype: str
        """
        return self._secret_engine_path

    @secret_engine_path.setter
    def secret_engine_path(self, secret_engine_path: str):
        """Sets the secret_engine_path of this Vault.

        Vault secret engine path where connection will be stored  # noqa: E501

        :param secret_engine_path: The secret_engine_path of this Vault.
        :type secret_engine_path: str
        """

        self._secret_engine_path = secret_engine_path

    @property
    def token(self) -> str:
        """Gets the token of this Vault.

        Optionally. Token for access to the vault server If it is empty then client will use the k8s auth  # noqa: E501

        :return: The token of this Vault.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token: str):
        """Sets the token of this Vault.

        Optionally. Token for access to the vault server If it is empty then client will use the k8s auth  # noqa: E501

        :param token: The token of this Vault.
        :type token: str
        """

        self._token = token

    @property
    def url(self) -> str:
        """Gets the url of this Vault.

        Vault URL  # noqa: E501

        :return: The url of this Vault.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str):
        """Sets the url of this Vault.

        Vault URL  # noqa: E501

        :param url: The url of this Vault.
        :type url: str
        """

        self._url = url
