# -*- coding: utf-8 -*-
import graphviz
import lxml
import edxml

from lxml import etree
from typing import List, Dict, Union, Type

from edxml.ontology import OntologyElement


class Ontology(OntologyElement):

    TEMPLATE_PATTERN = ...
    KNOWN_FORMATTERS = ...  # type: List[str]

    __bricks = {}  # type: Dict[str, edxml.ontology.Ontology]

    def __init__(self) -> None:
        self.__version = ...       # type: int
        self.__event_types = ...   # type: Dict[str, edxml.ontology.EventType]
        self.__object_types = ...  # type: Dict[str, edxml.ontology.ObjectType]
        self.__sources = ...       # type: Dict[str, edxml.ontology.EventSource]
        self.__concepts = ...      # type: Dict[str, edxml.ontology.Concept]

    def _child_modified_callback(self) -> 'Ontology': ...

    def clear(self) -> 'Ontology': ...

    def get_version(self) -> int: ...

    def is_modified_since(self, version: int) -> bool: ...

    @classmethod
    def register_brick(cls, brick: Type[edxml.ontology.Brick]): ...

    def _import_object_type_from_brick(self, object_type_name: str): ...

    def _import_concept_from_brick(self, concept_name: str): ...

    def create_object_type(self, name: str, display_name_singular: str = None, display_name_plural: str = None,
                           description: str = None, data_type: str = 'string:0:mc:u') -> edxml.ontology.ObjectType: ...

    def create_concept(self, name: str, display_name_singular: str = None, display_name_plural: str = None,
                       description: str = None) -> edxml.ontology.Concept: ...

    def create_event_type(self, name, display_name_singular=None, display_name_plural=None, description=None) -> edxml.ontology.EventType: ...

    def create_event_source(self, uri, description='no description available', acquisition_date='00000000') -> edxml.ontology.EventSource: ...

    def _add_event_type(self, event_type: edxml.ontology.EventType, validate: bool = True) -> 'Ontology': ...

    def _add_object_type(self, object_type: edxml.ontology.ObjectType, validate: bool = True) -> 'Ontology': ...

    def _add_concept(self, concept: edxml.ontology.Concept, validate: bool = True) -> 'Ontology': ...

    def _add_event_source(self, event_source: edxml.ontology.EventSource, validate: bool = True) -> 'Ontology': ...

    def delete_object_type(self, object_type_name: str) -> 'Ontology': ...

    def delete_concept(self, concept_name: str) -> 'Ontology': ...

    def delete_event_type(self, event_type_name: str) -> 'Ontology': ...

    def delete_event_source(self, source_uri: str) -> 'Ontology': ...

    def get_event_types(self) -> Dict[str, edxml.ontology.EventType]: ...

    def get_object_types(self) -> Dict[str, edxml.ontology.ObjectType]: ...

    def get_concepts(self) -> Dict[str, edxml.ontology.Concept]: ...

    def get_event_sources(self) -> Dict[str, edxml.ontology.EventSource]: ...

    def get_event_type_names(self) -> List[str]: ...

    def get_object_type_names(self) -> List[str]: ...

    def get_event_source_uris(self) -> List[str]: ...

    def get_concept_names(self) -> List[str]: ...

    def get_event_type(self, name: str) -> Union[edxml.ontology.EventType, None]: ...

    def get_object_type(self, name: str, import_brick: bool=True) -> Union[edxml.ontology.ObjectType, None]: ...

    def get_concept(self, name: str, import_brick: bool=True) -> Union[edxml.ontology.Concept, None]: ...

    def get_event_source(self, uri: str) -> Union[edxml.ontology.EventSource, None]: ...

    def __parse_event_types(self, event_types_element: etree.Element, validate: bool=True): ...

    def __parse_object_types(self, object_types_element: etree.Element, validate: bool=True): ...

    def __parse_concepts(self, concepts_element: etree.Element, validate: bool=True): ...

    def __parse_sources(self, sources_element: etree.Element, validate: bool=True): ...

    def validate(self) -> 'Ontology': ...

    @classmethod
    def create_from_xml(cls, element: etree.Element) -> 'OntologyElement': ...

    def update(self, other_ontology: Union[lxml.etree.Element, 'Ontology'], validate: bool = True) -> 'Ontology': ...

    def generate_xml(self) -> etree.Element: ...
