# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ConversationMessage(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'text': 'str',
        '_from': 'ModelFrom',
        'start_time': 'date',
        'end_time': 'date',
        'conversation_id': 'str',
        'phrases': 'list[Phrase]',
        'sentiment': 'Sentiment',
        'words': 'list[Word]'
    }

    attribute_map = {
        'id': 'id',
        'text': 'text',
        '_from': 'from',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'conversation_id': 'conversationId',
        'phrases': 'phrases',
        'sentiment': 'sentiment',
        'words': 'words'
    }

    def __init__(self, id=None, text=None, _from=None, start_time=None, end_time=None, conversation_id=None, phrases=None, sentiment=None, words=None):  # noqa: E501
        """ConversationMessage - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._text = None
        self.__from = None
        self._start_time = None
        self._end_time = None
        self._conversation_id = None
        self._phrases = None
        self._sentiment = None
        self._words = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if text is not None:
            self.text = text
        if _from is not None:
            self._from = _from
        if start_time is not None:
            self.start_time = start_time
        if end_time is not None:
            self.end_time = end_time
        if conversation_id is not None:
            self.conversation_id = conversation_id
        if phrases is not None:
            self.phrases = phrases
        if sentiment is not None:
            self.sentiment = sentiment
        if words is not None:
            self.words = words

    @property
    def id(self):
        """Gets the id of this ConversationMessage.  # noqa: E501


        :return: The id of this ConversationMessage.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ConversationMessage.


        :param id: The id of this ConversationMessage.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def text(self):
        """Gets the text of this ConversationMessage.  # noqa: E501


        :return: The text of this ConversationMessage.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this ConversationMessage.


        :param text: The text of this ConversationMessage.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def _from(self):
        """Gets the _from of this ConversationMessage.  # noqa: E501


        :return: The _from of this ConversationMessage.  # noqa: E501
        :rtype: ModelFrom
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """Sets the _from of this ConversationMessage.


        :param _from: The _from of this ConversationMessage.  # noqa: E501
        :type: ModelFrom
        """

        self.__from = _from

    @property
    def start_time(self):
        """Gets the start_time of this ConversationMessage.  # noqa: E501


        :return: The start_time of this ConversationMessage.  # noqa: E501
        :rtype: date
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this ConversationMessage.


        :param start_time: The start_time of this ConversationMessage.  # noqa: E501
        :type: date
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this ConversationMessage.  # noqa: E501


        :return: The end_time of this ConversationMessage.  # noqa: E501
        :rtype: date
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this ConversationMessage.


        :param end_time: The end_time of this ConversationMessage.  # noqa: E501
        :type: date
        """

        self._end_time = end_time

    @property
    def conversation_id(self):
        """Gets the conversation_id of this ConversationMessage.  # noqa: E501


        :return: The conversation_id of this ConversationMessage.  # noqa: E501
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """Sets the conversation_id of this ConversationMessage.


        :param conversation_id: The conversation_id of this ConversationMessage.  # noqa: E501
        :type: str
        """

        self._conversation_id = conversation_id

    @property
    def phrases(self):
        """Gets the phrases of this ConversationMessage.  # noqa: E501


        :return: The phrases of this ConversationMessage.  # noqa: E501
        :rtype: list[Phrase]
        """
        return self._phrases

    @phrases.setter
    def phrases(self, phrases):
        """Sets the phrases of this ConversationMessage.


        :param phrases: The phrases of this ConversationMessage.  # noqa: E501
        :type: list[Phrase]
        """

        self._phrases = phrases

    @property
    def sentiment(self):
        """Gets the sentiment of this ConversationMessage.  # noqa: E501


        :return: The sentiment of this ConversationMessage.  # noqa: E501
        :rtype: Sentiment
        """
        return self._sentiment

    @sentiment.setter
    def sentiment(self, sentiment):
        """Sets the sentiment of this ConversationMessage.


        :param sentiment: The sentiment of this ConversationMessage.  # noqa: E501
        :type: Sentiment
        """

        self._sentiment = sentiment

    @property
    def words(self):
        """Gets the words of this ConversationMessage.  # noqa: E501


        :return: The words of this ConversationMessage.  # noqa: E501
        :rtype: list[Word]
        """
        return self._words

    @words.setter
    def words(self, words):
        """Sets the words of this ConversationMessage.


        :param words: The words of this ConversationMessage.  # noqa: E501
        :type: list[Word]
        """

        self._words = words

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ConversationMessage, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConversationMessage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
