# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ConversationIntent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'text': 'str',
        'type': 'str',
        'score': 'float',
        'message_ids': 'list[str]',
        'intent': 'str',
        'alternatives': 'list[object]',
        'entities': 'list[Tag]'
    }

    attribute_map = {
        'id': 'id',
        'text': 'text',
        'type': 'type',
        'score': 'score',
        'message_ids': 'messageIds',
        'intent': 'intent',
        'alternatives': 'alternatives',
        'entities': 'entities'
    }

    def __init__(self, id=None, text=None, type=None, score=None, message_ids=None, intent=None, alternatives=None, entities=None):  # noqa: E501
        """ConversationIntent - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._text = None
        self._type = None
        self._score = None
        self._message_ids = None
        self._intent = None
        self._alternatives = None
        self._entities = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if text is not None:
            self.text = text
        if type is not None:
            self.type = type
        if score is not None:
            self.score = score
        if message_ids is not None:
            self.message_ids = message_ids
        if intent is not None:
            self.intent = intent
        if alternatives is not None:
            self.alternatives = alternatives
        if entities is not None:
            self.entities = entities

    @property
    def id(self):
        """Gets the id of this ConversationIntent.  # noqa: E501


        :return: The id of this ConversationIntent.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ConversationIntent.


        :param id: The id of this ConversationIntent.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def text(self):
        """Gets the text of this ConversationIntent.  # noqa: E501


        :return: The text of this ConversationIntent.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this ConversationIntent.


        :param text: The text of this ConversationIntent.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def type(self):
        """Gets the type of this ConversationIntent.  # noqa: E501


        :return: The type of this ConversationIntent.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ConversationIntent.


        :param type: The type of this ConversationIntent.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def score(self):
        """Gets the score of this ConversationIntent.  # noqa: E501


        :return: The score of this ConversationIntent.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this ConversationIntent.


        :param score: The score of this ConversationIntent.  # noqa: E501
        :type: float
        """

        self._score = score

    @property
    def message_ids(self):
        """Gets the message_ids of this ConversationIntent.  # noqa: E501


        :return: The message_ids of this ConversationIntent.  # noqa: E501
        :rtype: list[str]
        """
        return self._message_ids

    @message_ids.setter
    def message_ids(self, message_ids):
        """Sets the message_ids of this ConversationIntent.


        :param message_ids: The message_ids of this ConversationIntent.  # noqa: E501
        :type: list[str]
        """

        self._message_ids = message_ids

    @property
    def intent(self):
        """Gets the intent of this ConversationIntent.  # noqa: E501


        :return: The intent of this ConversationIntent.  # noqa: E501
        :rtype: str
        """
        return self._intent

    @intent.setter
    def intent(self, intent):
        """Sets the intent of this ConversationIntent.


        :param intent: The intent of this ConversationIntent.  # noqa: E501
        :type: str
        """

        self._intent = intent

    @property
    def alternatives(self):
        """Gets the alternatives of this ConversationIntent.  # noqa: E501

        List of other intents detected with scores  # noqa: E501

        :return: The alternatives of this ConversationIntent.  # noqa: E501
        :rtype: list[object]
        """
        return self._alternatives

    @alternatives.setter
    def alternatives(self, alternatives):
        """Sets the alternatives of this ConversationIntent.

        List of other intents detected with scores  # noqa: E501

        :param alternatives: The alternatives of this ConversationIntent.  # noqa: E501
        :type: list[object]
        """

        self._alternatives = alternatives

    @property
    def entities(self):
        """Gets the entities of this ConversationIntent.  # noqa: E501


        :return: The entities of this ConversationIntent.  # noqa: E501
        :rtype: list[Tag]
        """
        return self._entities

    @entities.setter
    def entities(self, entities):
        """Sets the entities of this ConversationIntent.


        :param entities: The entities of this ConversationIntent.  # noqa: E501
        :type: list[Tag]
        """

        self._entities = entities

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ConversationIntent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConversationIntent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
