# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Conversation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'type': 'str',
        'name': 'str',
        'start_time': 'date',
        'end_time': 'date',
        'transcript_id': 'str',
        'media_url': 'str',
        'members': 'list[MembersInfo]'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'name': 'name',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'transcript_id': 'transcriptId',
        'media_url': 'mediaUrl',
        'members': 'members'
    }

    def __init__(self, id=None, type=None, name=None, start_time=None, end_time=None, transcript_id=None, media_url=None, members=None):  # noqa: E501
        """Conversation - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._type = None
        self._name = None
        self._start_time = None
        self._end_time = None
        self._transcript_id = None
        self._media_url = None
        self._members = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if type is not None:
            self.type = type
        if name is not None:
            self.name = name
        if start_time is not None:
            self.start_time = start_time
        if end_time is not None:
            self.end_time = end_time
        if transcript_id is not None:
            self.transcript_id = transcript_id
        if media_url is not None:
            self.media_url = media_url
        if members is not None:
            self.members = members

    @property
    def id(self):
        """Gets the id of this Conversation.  # noqa: E501


        :return: The id of this Conversation.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Conversation.


        :param id: The id of this Conversation.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this Conversation.  # noqa: E501


        :return: The type of this Conversation.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Conversation.


        :param type: The type of this Conversation.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def name(self):
        """Gets the name of this Conversation.  # noqa: E501


        :return: The name of this Conversation.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Conversation.


        :param name: The name of this Conversation.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def start_time(self):
        """Gets the start_time of this Conversation.  # noqa: E501


        :return: The start_time of this Conversation.  # noqa: E501
        :rtype: date
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this Conversation.


        :param start_time: The start_time of this Conversation.  # noqa: E501
        :type: date
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this Conversation.  # noqa: E501


        :return: The end_time of this Conversation.  # noqa: E501
        :rtype: date
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this Conversation.


        :param end_time: The end_time of this Conversation.  # noqa: E501
        :type: date
        """

        self._end_time = end_time

    @property
    def transcript_id(self):
        """Gets the transcript_id of this Conversation.  # noqa: E501


        :return: The transcript_id of this Conversation.  # noqa: E501
        :rtype: str
        """
        return self._transcript_id

    @transcript_id.setter
    def transcript_id(self, transcript_id):
        """Sets the transcript_id of this Conversation.


        :param transcript_id: The transcript_id of this Conversation.  # noqa: E501
        :type: str
        """

        self._transcript_id = transcript_id

    @property
    def media_url(self):
        """Gets the media_url of this Conversation.  # noqa: E501


        :return: The media_url of this Conversation.  # noqa: E501
        :rtype: str
        """
        return self._media_url

    @media_url.setter
    def media_url(self, media_url):
        """Sets the media_url of this Conversation.


        :param media_url: The media_url of this Conversation.  # noqa: E501
        :type: str
        """

        self._media_url = media_url

    @property
    def members(self):
        """Gets the members of this Conversation.  # noqa: E501


        :return: The members of this Conversation.  # noqa: E501
        :rtype: list[MembersInfo]
        """
        return self._members

    @members.setter
    def members(self, members):
        """Sets the members of this Conversation.


        :param members: The members of this Conversation.  # noqa: E501
        :type: list[MembersInfo]
        """

        self._members = members

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Conversation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Conversation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
