#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['dnnv',
 'dnnv.cli',
 'dnnv.logging',
 'dnnv.nn',
 'dnnv.nn.analyzers',
 'dnnv.nn.converters',
 'dnnv.nn.layers',
 'dnnv.nn.operations',
 'dnnv.nn.parser',
 'dnnv.nn.transformers',
 'dnnv.nn.transformers.simplifiers',
 'dnnv.properties',
 'dnnv.verifiers',
 'dnnv.verifiers.bab',
 'dnnv.verifiers.common',
 'dnnv.verifiers.common.executors',
 'dnnv.verifiers.common.reductions',
 'dnnv.verifiers.convert',
 'dnnv.verifiers.eran',
 'dnnv.verifiers.marabou',
 'dnnv.verifiers.mipverify',
 'dnnv.verifiers.neurify',
 'dnnv.verifiers.nnenum',
 'dnnv.verifiers.planet',
 'dnnv.verifiers.reluplex',
 'dnnv.verifiers.verinet']

package_data = \
{'': ['*'],
 'dnnv': ['_manage/*',
          '_manage/linux/*',
          '_manage/linux/environment/*',
          '_manage/linux/environment/dependencies/*',
          '_manage/linux/environment/dependencies/installers/*',
          '_manage/linux/verifiers/*',
          'logging_utils/*'],
 'dnnv.verifiers': ['babsb/*']}

install_requires = \
['numpy >=1.18,<1.20',
 'onnx >=1.7,<1.8',
 'psutil >=5.6,<5.7',
 'scipy >=1.4,<1.6',
 'tensorflow >=1.15,<2.3',
 'keras >=2.3,<2.4',
 'simpleparse >=2.2,<2.3',
 'torch >=1.5,<1.7',
 'torchvision >=0.6,<0.8']

extras_require = \
{'dev': ['black', 'mypy'],
 'doc': ['sphinx'],
 'test': ['toml >=0.10,<0.11', 'coverage >=5.0,<5.3']}

entry_points = \
{'console_scripts': ['dnnv = dnnv.__main__:_main']}

setup(name='dnnv',
      version='0.4.8',
      description='dnnv - deep neural network verification',
      author='David Shriver',
      author_email='dls2fc@virginia.edu',
      url='https://github.com/dlshriver/DNNV',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
