"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNlbIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const integration_1 = require("./private/integration");
/**
 * (experimental) The Network Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
class HttpNlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        this.props = props;
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        let vpc = (_b = this.props.vpcLink) === null || _b === void 0 ? void 0 : _b.vpc;
        if (!vpc && (this.props.listener instanceof elbv2.NetworkListener)) {
            vpc = this.props.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Network Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: (_c = this.props.method) !== null && _c !== void 0 ? _c : this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.props.listener.listenerArn,
            secureServerName: this.props.secureServerName,
        };
    }
}
exports.HttpNlbIntegration = HttpNlbIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpNlbIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpNlbIntegration", version: "2.0.0-rc.23" };
//# sourceMappingURL=data:application/json;base64,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