import { HttpMethod, IVpcLink } from '@aws-cdk/aws-apigatewayv2-alpha';
/**
 * (experimental) Base options for private integration.
 *
 * @experimental
 */
export interface HttpPrivateIntegrationOptions {
    /**
     * (experimental) The vpc link to be used for the private integration.
     *
     * @default - a new VpcLink is created
     * @experimental
     */
    readonly vpcLink?: IVpcLink;
    /**
     * (experimental) The HTTP method that must be used to invoke the underlying HTTP proxy.
     *
     * @default HttpMethod.ANY
     * @experimental
     */
    readonly method?: HttpMethod;
    /**
     * (experimental) Specifies the server name to verified by HTTPS when calling the backend integration.
     *
     * @default undefined private integration traffic will use HTTP protocol
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html
     * @experimental
     */
    readonly secureServerName?: string;
}
