"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InlineLambdaConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
/**
 * A simple CDK construct to create a Lambda function with static inline code that prints the event and calls the callback function.
 *
 * @stability stable
 */
class InlineLambdaConstruct extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(parent, name) {
        super(parent, name);
        new aws_lambda_1.Function(this, 'SampleFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromInline('exports.handler = function (e, ctx, cb) { console.log("Event: ", e); cb(); };'),
            handler: 'index.handler',
            timeout: core_1.Duration.seconds(10),
        });
    }
}
exports.InlineLambdaConstruct = InlineLambdaConstruct;
_a = JSII_RTTI_SYMBOL_1;
InlineLambdaConstruct[_a] = { fqn: "@seeebiii/projen-test.InlineLambdaConstruct", version: "0.1.15" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxvREFBOEQ7QUFDOUQsd0NBQW9EOzs7Ozs7QUFLcEQsTUFBYSxxQkFBc0IsU0FBUSxnQkFBUzs7OztJQUNsRCxZQUFZLE1BQWlCLEVBQUUsSUFBWTtRQUN6QyxLQUFLLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBRXBCLElBQUkscUJBQVEsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7WUFDbkMsT0FBTyxFQUFFLG9CQUFPLENBQUMsV0FBVztZQUM1QixJQUFJLEVBQUUsaUJBQUksQ0FBQyxVQUFVLENBQUMsK0VBQStFLENBQUM7WUFDdEcsT0FBTyxFQUFFLGVBQWU7WUFDeEIsT0FBTyxFQUFFLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1NBQzlCLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBVkgsc0RBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb2RlLCBGdW5jdGlvbiwgUnVudGltZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBEdXJhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIElubGluZUxhbWJkYUNvbnN0cnVjdCBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHBhcmVudDogQ29uc3RydWN0LCBuYW1lOiBzdHJpbmcpIHtcbiAgICBzdXBlcihwYXJlbnQsIG5hbWUpO1xuXG4gICAgbmV3IEZ1bmN0aW9uKHRoaXMsICdTYW1wbGVGdW5jdGlvbicsIHtcbiAgICAgIHJ1bnRpbWU6IFJ1bnRpbWUuTk9ERUpTXzEyX1gsXG4gICAgICBjb2RlOiBDb2RlLmZyb21JbmxpbmUoJ2V4cG9ydHMuaGFuZGxlciA9IGZ1bmN0aW9uIChlLCBjdHgsIGNiKSB7IGNvbnNvbGUubG9nKFwiRXZlbnQ6IFwiLCBlKTsgY2IoKTsgfTsnKSxcbiAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMoMTApLFxuICAgIH0pO1xuICB9XG59XG4iXX0=