# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WebDeploymentsOAuthExchangeRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WebDeploymentsOAuthExchangeRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'deployment_id': 'str',
            'journey_context': 'WebDeploymentsJourneyContext',
            'oauth': 'WebDeploymentsOAuthRequestParameters'
        }

        self.attribute_map = {
            'deployment_id': 'deploymentId',
            'journey_context': 'journeyContext',
            'oauth': 'oauth'
        }

        self._deployment_id = None
        self._journey_context = None
        self._oauth = None

    @property
    def deployment_id(self):
        """
        Gets the deployment_id of this WebDeploymentsOAuthExchangeRequest.
        The WebDeployment ID

        :return: The deployment_id of this WebDeploymentsOAuthExchangeRequest.
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """
        Sets the deployment_id of this WebDeploymentsOAuthExchangeRequest.
        The WebDeployment ID

        :param deployment_id: The deployment_id of this WebDeploymentsOAuthExchangeRequest.
        :type: str
        """
        

        self._deployment_id = deployment_id

    @property
    def journey_context(self):
        """
        Gets the journey_context of this WebDeploymentsOAuthExchangeRequest.
        A Customer journey context.

        :return: The journey_context of this WebDeploymentsOAuthExchangeRequest.
        :rtype: WebDeploymentsJourneyContext
        """
        return self._journey_context

    @journey_context.setter
    def journey_context(self, journey_context):
        """
        Sets the journey_context of this WebDeploymentsOAuthExchangeRequest.
        A Customer journey context.

        :param journey_context: The journey_context of this WebDeploymentsOAuthExchangeRequest.
        :type: WebDeploymentsJourneyContext
        """
        

        self._journey_context = journey_context

    @property
    def oauth(self):
        """
        Gets the oauth of this WebDeploymentsOAuthExchangeRequest.


        :return: The oauth of this WebDeploymentsOAuthExchangeRequest.
        :rtype: WebDeploymentsOAuthRequestParameters
        """
        return self._oauth

    @oauth.setter
    def oauth(self, oauth):
        """
        Sets the oauth of this WebDeploymentsOAuthExchangeRequest.


        :param oauth: The oauth of this WebDeploymentsOAuthExchangeRequest.
        :type: WebDeploymentsOAuthRequestParameters
        """
        

        self._oauth = oauth

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

