# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SurveyErrorDetails(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SurveyErrorDetails - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'flow_diagnostic_info': 'FlowDiagnosticInfo',
            'survey_error_reason': 'str'
        }

        self.attribute_map = {
            'flow_diagnostic_info': 'flowDiagnosticInfo',
            'survey_error_reason': 'surveyErrorReason'
        }

        self._flow_diagnostic_info = None
        self._survey_error_reason = None

    @property
    def flow_diagnostic_info(self):
        """
        Gets the flow_diagnostic_info of this SurveyErrorDetails.
        Additional information about any errors that occurred in the survey invite flow.

        :return: The flow_diagnostic_info of this SurveyErrorDetails.
        :rtype: FlowDiagnosticInfo
        """
        return self._flow_diagnostic_info

    @flow_diagnostic_info.setter
    def flow_diagnostic_info(self, flow_diagnostic_info):
        """
        Sets the flow_diagnostic_info of this SurveyErrorDetails.
        Additional information about any errors that occurred in the survey invite flow.

        :param flow_diagnostic_info: The flow_diagnostic_info of this SurveyErrorDetails.
        :type: FlowDiagnosticInfo
        """
        

        self._flow_diagnostic_info = flow_diagnostic_info

    @property
    def survey_error_reason(self):
        """
        Gets the survey_error_reason of this SurveyErrorDetails.
        An error code indicating the reason for the survey failure.

        :return: The survey_error_reason of this SurveyErrorDetails.
        :rtype: str
        """
        return self._survey_error_reason

    @survey_error_reason.setter
    def survey_error_reason(self, survey_error_reason):
        """
        Sets the survey_error_reason of this SurveyErrorDetails.
        An error code indicating the reason for the survey failure.

        :param survey_error_reason: The survey_error_reason of this SurveyErrorDetails.
        :type: str
        """
        

        self._survey_error_reason = survey_error_reason

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

