# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class PredictorModelBrief(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        PredictorModelBrief - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'media_type': 'str',
            'date_modified': 'datetime',
            'retraining_errors': 'list[PredictorModelRetrainingError]',
            'state': 'str'
        }

        self.attribute_map = {
            'media_type': 'mediaType',
            'date_modified': 'dateModified',
            'retraining_errors': 'retrainingErrors',
            'state': 'state'
        }

        self._media_type = None
        self._date_modified = None
        self._retraining_errors = None
        self._state = None

    @property
    def media_type(self):
        """
        Gets the media_type of this PredictorModelBrief.
        The media type of the model.

        :return: The media_type of this PredictorModelBrief.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type):
        """
        Sets the media_type of this PredictorModelBrief.
        The media type of the model.

        :param media_type: The media_type of this PredictorModelBrief.
        :type: str
        """
        allowed_values = ["voice", "email", "message"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def date_modified(self):
        """
        Gets the date_modified of this PredictorModelBrief.
        The date the model was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this PredictorModelBrief.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this PredictorModelBrief.
        The date the model was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this PredictorModelBrief.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def retraining_errors(self):
        """
        Gets the retraining_errors of this PredictorModelBrief.
        The model's retraining errors.

        :return: The retraining_errors of this PredictorModelBrief.
        :rtype: list[PredictorModelRetrainingError]
        """
        return self._retraining_errors

    @retraining_errors.setter
    def retraining_errors(self, retraining_errors):
        """
        Sets the retraining_errors of this PredictorModelBrief.
        The model's retraining errors.

        :param retraining_errors: The retraining_errors of this PredictorModelBrief.
        :type: list[PredictorModelRetrainingError]
        """
        

        self._retraining_errors = retraining_errors

    @property
    def state(self):
        """
        Gets the state of this PredictorModelBrief.
        The state of the model

        :return: The state of this PredictorModelBrief.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this PredictorModelBrief.
        The state of the model

        :param state: The state of this PredictorModelBrief.
        :type: str
        """
        allowed_values = ["Trained", "Error", "InvalidDataset", "Inactive"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

