# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class MatchCriteriaTestResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        MatchCriteriaTestResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'json_path': 'str',
            'operator': 'str',
            'value': 'object',
            'values': 'list[object]',
            'generated_json_path_condition': 'str',
            'match': 'bool',
            'json_path_extraction': 'list[MatchTestResult]'
        }

        self.attribute_map = {
            'json_path': 'jsonPath',
            'operator': 'operator',
            'value': 'value',
            'values': 'values',
            'generated_json_path_condition': 'generatedJsonPathCondition',
            'match': 'match',
            'json_path_extraction': 'jsonPathExtraction'
        }

        self._json_path = None
        self._operator = None
        self._value = None
        self._values = None
        self._generated_json_path_condition = None
        self._match = None
        self._json_path_extraction = None

    @property
    def json_path(self):
        """
        Gets the json_path of this MatchCriteriaTestResult.
        The Goessner json path of the field to match

        :return: The json_path of this MatchCriteriaTestResult.
        :rtype: str
        """
        return self._json_path

    @json_path.setter
    def json_path(self, json_path):
        """
        Sets the json_path of this MatchCriteriaTestResult.
        The Goessner json path of the field to match

        :param json_path: The json_path of this MatchCriteriaTestResult.
        :type: str
        """
        

        self._json_path = json_path

    @property
    def operator(self):
        """
        Gets the operator of this MatchCriteriaTestResult.
        The type of operation to perform for matching check

        :return: The operator of this MatchCriteriaTestResult.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this MatchCriteriaTestResult.
        The type of operation to perform for matching check

        :param operator: The operator of this MatchCriteriaTestResult.
        :type: str
        """
        allowed_values = ["GreaterThanOrEqual", "LessThanOrEqual", "Equal", "NotEqual", "LessThan", "GreaterThan", "NotIn", "In", "Contains", "All", "Exists", "Size"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def value(self):
        """
        Gets the value of this MatchCriteriaTestResult.
        The value to match on. Only one of value and values can be included

        :return: The value of this MatchCriteriaTestResult.
        :rtype: object
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this MatchCriteriaTestResult.
        The value to match on. Only one of value and values can be included

        :param value: The value of this MatchCriteriaTestResult.
        :type: object
        """
        

        self._value = value

    @property
    def values(self):
        """
        Gets the values of this MatchCriteriaTestResult.
        The list of values to match on. Only one of value and values can be included

        :return: The values of this MatchCriteriaTestResult.
        :rtype: list[object]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this MatchCriteriaTestResult.
        The list of values to match on. Only one of value and values can be included

        :param values: The values of this MatchCriteriaTestResult.
        :type: list[object]
        """
        

        self._values = values

    @property
    def generated_json_path_condition(self):
        """
        Gets the generated_json_path_condition of this MatchCriteriaTestResult.
        The generated json path condition

        :return: The generated_json_path_condition of this MatchCriteriaTestResult.
        :rtype: str
        """
        return self._generated_json_path_condition

    @generated_json_path_condition.setter
    def generated_json_path_condition(self, generated_json_path_condition):
        """
        Sets the generated_json_path_condition of this MatchCriteriaTestResult.
        The generated json path condition

        :param generated_json_path_condition: The generated_json_path_condition of this MatchCriteriaTestResult.
        :type: str
        """
        

        self._generated_json_path_condition = generated_json_path_condition

    @property
    def match(self):
        """
        Gets the match of this MatchCriteriaTestResult.
        Did the generated json path condition match

        :return: The match of this MatchCriteriaTestResult.
        :rtype: bool
        """
        return self._match

    @match.setter
    def match(self, match):
        """
        Sets the match of this MatchCriteriaTestResult.
        Did the generated json path condition match

        :param match: The match of this MatchCriteriaTestResult.
        :type: bool
        """
        

        self._match = match

    @property
    def json_path_extraction(self):
        """
        Gets the json_path_extraction of this MatchCriteriaTestResult.
        The json paths and their values that were compared

        :return: The json_path_extraction of this MatchCriteriaTestResult.
        :rtype: list[MatchTestResult]
        """
        return self._json_path_extraction

    @json_path_extraction.setter
    def json_path_extraction(self, json_path_extraction):
        """
        Sets the json_path_extraction of this MatchCriteriaTestResult.
        The json paths and their values that were compared

        :param json_path_extraction: The json_path_extraction of this MatchCriteriaTestResult.
        :type: list[MatchTestResult]
        """
        

        self._json_path_extraction = json_path_extraction

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

