# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class InitiatingAction(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        InitiatingAction - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'transaction_id': 'str',
            'action_context': 'str'
        }

        self.attribute_map = {
            'transaction_id': 'transactionId',
            'action_context': 'actionContext'
        }

        self._transaction_id = None
        self._action_context = None

    @property
    def transaction_id(self):
        """
        Gets the transaction_id of this InitiatingAction.
        Id of the audit initiating the transaction

        :return: The transaction_id of this InitiatingAction.
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """
        Sets the transaction_id of this InitiatingAction.
        Id of the audit initiating the transaction

        :param transaction_id: The transaction_id of this InitiatingAction.
        :type: str
        """
        

        self._transaction_id = transaction_id

    @property
    def action_context(self):
        """
        Gets the action_context of this InitiatingAction.
        Action of the audit initiating the transaction

        :return: The action_context of this InitiatingAction.
        :rtype: str
        """
        return self._action_context

    @action_context.setter
    def action_context(self, action_context):
        """
        Sets the action_context of this InitiatingAction.
        Action of the audit initiating the transaction

        :param action_context: The action_context of this InitiatingAction.
        :type: str
        """
        allowed_values = ["Create", "View", "Update", "Move", "Copy", "Delete", "DeleteAll", "Fax", "VersionCreate", "Download", "Upload", "MemberAdd", "MemberUpdate", "MemberRemove", "ShareAdd", "ShareRemove", "TagAdd", "TagRemove", "TagUpdate", "Read", "ReadAll", "Execute", "ApplyProtection", "RevokeProtection", "UpdateRetention", "Abandon", "Archive", "RestoreRequest", "RestoreComplete", "Promote", "Publish", "Unpublish", "Activate", "Checkin", "Checkout", "Deactivate", "Debug", "Save", "Revert", "Transcode", "Enable", "Disable", "Authorize", "Deauthorize", "Authenticate", "ChangePassword", "Revoke", "Export", "Append", "Recycle", "Open", "Approved", "Rejected", "Rollback", "ImplementingChange", "ChangeImplemented", "ImplementingRollback", "RollbackImplemented", "Write", "Purge", "Processed", "Remove", "Replace", "UpdateInService", "UpdateOutOfService", "Cycle", "Scale", "IpAllowlistClear", "AddPairingRole", "Add", "Verify", "Assign", "Unassign", "Reassign", "Reschedule", "Cancel", "SoftDelete", "HardDelete", "Reset", "Rotate", "Restore", "Unarchive", "EnableCapture", "DownloadCapture"]
        if action_context.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action_context -> " + action_context)
            self._action_context = "outdated_sdk_version"
        else:
            self._action_context = action_context

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

