# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ColumnDataTypeSpecification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ColumnDataTypeSpecification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'column_name': 'str',
            'column_data_type': 'str',
            'min': 'int',
            'max': 'int',
            'max_length': 'int'
        }

        self.attribute_map = {
            'column_name': 'columnName',
            'column_data_type': 'columnDataType',
            'min': 'min',
            'max': 'max',
            'max_length': 'maxLength'
        }

        self._column_name = None
        self._column_data_type = None
        self._min = None
        self._max = None
        self._max_length = None

    @property
    def column_name(self):
        """
        Gets the column_name of this ColumnDataTypeSpecification.
        The column name of a column selected for dynamic queueing

        :return: The column_name of this ColumnDataTypeSpecification.
        :rtype: str
        """
        return self._column_name

    @column_name.setter
    def column_name(self, column_name):
        """
        Sets the column_name of this ColumnDataTypeSpecification.
        The column name of a column selected for dynamic queueing

        :param column_name: The column_name of this ColumnDataTypeSpecification.
        :type: str
        """
        

        self._column_name = column_name

    @property
    def column_data_type(self):
        """
        Gets the column_data_type of this ColumnDataTypeSpecification.
        The data type of the column selected for dynamic queueing (TEXT, NUMERIC or TIMESTAMP)

        :return: The column_data_type of this ColumnDataTypeSpecification.
        :rtype: str
        """
        return self._column_data_type

    @column_data_type.setter
    def column_data_type(self, column_data_type):
        """
        Sets the column_data_type of this ColumnDataTypeSpecification.
        The data type of the column selected for dynamic queueing (TEXT, NUMERIC or TIMESTAMP)

        :param column_data_type: The column_data_type of this ColumnDataTypeSpecification.
        :type: str
        """
        allowed_values = ["NUMERIC", "TEXT", "TIMESTAMP"]
        if column_data_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for column_data_type -> " + column_data_type)
            self._column_data_type = "outdated_sdk_version"
        else:
            self._column_data_type = column_data_type

    @property
    def min(self):
        """
        Gets the min of this ColumnDataTypeSpecification.
        The minimum length of the numeric column selected for dynamic queueing

        :return: The min of this ColumnDataTypeSpecification.
        :rtype: int
        """
        return self._min

    @min.setter
    def min(self, min):
        """
        Sets the min of this ColumnDataTypeSpecification.
        The minimum length of the numeric column selected for dynamic queueing

        :param min: The min of this ColumnDataTypeSpecification.
        :type: int
        """
        

        self._min = min

    @property
    def max(self):
        """
        Gets the max of this ColumnDataTypeSpecification.
        The maximum length of the numeric column selected for dynamic queueing

        :return: The max of this ColumnDataTypeSpecification.
        :rtype: int
        """
        return self._max

    @max.setter
    def max(self, max):
        """
        Sets the max of this ColumnDataTypeSpecification.
        The maximum length of the numeric column selected for dynamic queueing

        :param max: The max of this ColumnDataTypeSpecification.
        :type: int
        """
        

        self._max = max

    @property
    def max_length(self):
        """
        Gets the max_length of this ColumnDataTypeSpecification.
        The maximum length of the text column selected for dynamic queueing

        :return: The max_length of this ColumnDataTypeSpecification.
        :rtype: int
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """
        Sets the max_length of this ColumnDataTypeSpecification.
        The maximum length of the text column selected for dynamic queueing

        :param max_length: The max_length of this ColumnDataTypeSpecification.
        :type: int
        """
        

        self._max_length = max_length

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

