package kernel

import (
	"time"

	"github.com/MixinNetwork/mixin/crypto"
)

var (
	SnapshotRoundDayLeapForkHack, _  = time.Parse(time.RFC3339, "2021-02-19T00:00:00Z")
	ElectionTransactionV2ForkHack, _ = time.Parse(time.RFC3339, "2021-03-10T00:00:00Z")

	TransactionEmptyOutputsForkHack    = "ed6114706e8a0491c6b254167a9812128f5b29e88594ff8656cc69f4e5b410ce"
	TransactionScriptThresholdForkHack = "2a311e994281ab384f1d86fca7b7f2ef30ac34e5ba65dea16b976eb342e4f7ec"
	TransactionMintWorkHacks           = map[int]string{
		895: "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",
	}
	TransactionDepositOutputsForkHacks = map[string]bool{
		"5ae19842fa0d10ac13f4215a37f9eed3d7563f9af6a1b7ac3d412e05e49254b3": true,
		"f0ae6ae9f615ac1fda8899e6aa57e07e679f94e65dca0439a32a80b1f0e31ac2": true,
		"2c9d45385d9ebf19b87fb1bbbd638e489740cf86d10d1ca747eb09f13f5b6c12": true,
		"22082e074b5e8305ff07ab85bdecc0e7db8ad7e33b73976af860d6f8e2cc3d3e": true,
		"783c3a88a2e04e3a51c3870194899221bb5c5192caccc6e3eee7f34aa755a0fc": true,
		"1bd2038a94b4d8eb1bb2000613cb2c13cba7580cbf4cfc5ba1e43297796bda6a": true,
		"1d5a283fbee042ca6e2d2adfd5506271903c83c2d8f27e82ee5e91253d940405": true,
		"98540003449eb7645a9ff870c9006aae79dd0b32954b72cccf0f95cd536f031e": true,
		"59acca27ad0615296972cdcbe8c3cf350fba761ca1b25101ffeb37d25df957f5": true,
		"282647c057c8dd5babdf52c2a673f5530a464f1e076c62b6fe2700064781a503": true,
		"247259fed1e4fdbe9b9a0356bbf0a956b4369f11cd507a0900f32c5f988d82b7": true,
		"a1e0dd89d687cd7de3782d5e6e8449a1e95b99b4ad63a584f9267fb01695547a": true,
		"b22a507f975c8783a075ff6b76a2932bde730a0a48916c3b98dbc5ff5fce0b43": true,
		"bdb6467e14dc10edcca5e89af4198b3ab1cdabc8a2423486103b8f6c4895645e": true,
		"e37d71f64fd25fa31de4633963b3f0a15bff4718c057def74565345af8e58e86": true,
		"82db9b856e4ba24846a72f47d934c7cd760a1f8db8987545908eb7176e071e3b": true,
		"3db5113b4ff7435bffff4aff01f751766f2f0fc17570b437a77d63758e906e98": true,
		"0204f4356a5c79339b894869cb4a9d3bae2a448a20e11fb83e065a8efa2296cb": true,
		"93f7132751bb629420fa8fe37d2e387930353d87b9e3fc6dd5ff612828567230": true,
		"777942079b1c32a4367d90a93980859fc61ee445b06d075e07f46cc1e80b41c0": true,
		"7aae17087a36a3d039a886e550fd2b967c9e75902d9f80f09f25e30cd9ff3dd3": true,
		"39eba79d23fb089c9fd91607b32792c8edb6f807d09b0d3ca32a8108030e09d6": true,
		"5b9616fdc8eaca2bc139147a6c52f93abc61bf54f6e32acba2d1112476c17ff3": true,
		"ce4f56e565a7f148a87a36800a2412fe3e7e5d12cfcc06cfb932478baa13cce6": true,
		"a77ad863c5fc8e0c9977919036d3d48ab9e085044b6d96321c7909c5fd6da0d7": true,
		"e0407dbba91b5a492d46d5e4dd0f2b49ab4080a3560ec4cf3605d96e6d6af342": true,
		"6c4c52566f209f99d01f719fc8d85765389e235fa41ce6de3229e7b127c143e8": true,
		"85b2008ff3ca74b541e089df1c9b65813bc84b97d78d393625cdb36440bab23f": true,
		"5241897a340af1c57d1efd37781223121b5c9bc9a7690e1dcea4a72a0e2b7f56": true,
		"12c90f0d5d926506fb814b52fd5997a5df076e2e68cd14d62473d4067c0e4718": true,
		"8d0181131e2ad45df111d86b757818e8973c16d9819ce9024c5261a185cadae0": true,
		"62d85394f05863fa62f8dcb9c2613731785378e6ab25d69af572305fd626f934": true,
		"948cd6e2a42e3ff678dc46f3318590b41ffe3295d224faada8408da112c102cc": true,
		"b03e942f21857437ad172453f344b3c4c437303116cb344f9a90dd0cf5bd85ed": true,
		"b4bd75ff8749778a8b203e6e312f612df62c59cb8fa97e5fe715c2729499f247": true,
		"75f403f6c40ff41ccedcf100c2f03b0d9b845f8b484d9f8f6ae616ddb75982ca": true,
		"222fde94ab0bdd9b6e4a1edeeff5f5a6f4d4a715641b6d14e8bcb882c061ec7b": true,
		"56e88f457aee1e3fb010b9d9d75eba8a5760922de4fb1066f7193689c1e558c2": true,
		"d6676b1a195aa7e74eee73cac844237a138f2f6b52a8045a24c3d1958ca35a98": true,
		"0bd6bd79f537a702a5940004abecf29cecab808b606b710a63ec2b88228cfe24": true,
		"aeb33e2acfc96880e3a62be7f9853a89344730e3907862399bbba225b084738e": true,
		"bfeceedbc15a333049d3601282511f577e0441dc052bad4f0ba021dd7b294466": true,
		"3e06d73ff94dfa9e2424c5f329f4783b124a4b2efc1ca334e17eda929a267232": true,
		"920c11fc4314488c6a917285ef9112c69e16691d2cdfa35d4e966526f87f31d8": true,
		"95bef697b5f42b880da76d5ad76b8678a310a085ae3eb5a33f72b7b2e6ad1490": true,
		"ce98b2e73a2275aa33936a2dddb4eb85a4adaf7ed31cb37546e9e114d3ca14b8": true,
		"43fb2c892adce56955b5d175d33d0cc8c1636fb4dc35e9ccce84c19fa0114a0a": true,
		"7dd37bb332bd29a7444b6852e1a66bad98b2391968801a270f721f6a30a1385a": true,
		"f13cb53fdfb02ff6063b25c088fb458912d5137bfdb5c26ad643a57790e187e1": true,
		"9a089d8bc03f03e3373ea8602def58a677d219ccfede2a370201be98dbdcbe0e": true,
		"57e821b9daf6bf6a703c07bf53236538938eb0977dd0a04a832341a29267f0a9": true,
		"dedb3b62b85e6e973bec219b97c513a1ff77562e519c1c29c68b4d7f4d6a59bb": true,
		"255139774fa9a0c21ea6133f7fb5663170d37de4c45adec9a883883e5ccbf3c8": true,
		"52191a55ea52e350d253bc899279c76fb9dddb077d2d474b3723515e991175a7": true,
		"6fa11c9afc7d05c44372616d7e0c385d960dd9aa18f38086a2df22e58faacf40": true,
		"8fd5b64b1ca49a6982f7eeb8291c85aa31ab66b84413005668c1594ad6bd820f": true,
		"98a533cebd2babcf0275e506cfb0cf336f1a81cddbea4fd5fc4f2fad98537b39": true,
		"418204438add112369b08f22dd2941e10ec176aafd9ee39dd1931e1646e6f7d8": true,
		"9ec41718bdf7e9cb4a9acae833bafb44a083d53677d65822d56c0925f6e50266": true,
		"920f4907ca379f97a3e4e2a86b260990007abdfe54537a4020571ef9949f5b65": true,
		"128d814d659d367054d670296a192e4e4f01aa1d22871b72f2765a660bbb1eb9": true,
		"5df7bb239e84b53fca5652e2a333a446b9f9e4102593ef4360467997db9d9f44": true,
		"713f4d6e9f40e6f7abd108a484d45b3ec464ebd3cef2fb0c4109345979fea6e7": true,
		"2ea11629e2eb73988c996e63b1e4eeb743cb37279d9ad635588fcf47127b4ee4": true,
		"8218347433ed554f82747b442b469062b9a8fa75b0a3480432bb1819f158c898": true,
		"4f07e8e961793234be9aea766d2f4ffa101ec8caef346ff1941338394767a615": true,
		"2d2b9c931a7db30d5daac2ffdbee524053b3dd9e8d3611de1e67e07b3df2b4da": true,
		"f7b92c29d6eb1352008218af78cb55628112e21df70c52b9e65d4aa47b2619ac": true,
		"5f248587bcdc55bd6bbf891aed124cec4989b2f5388331352f3802b3069dd854": true,
		"aae1f18dbbe814ee232b9d10222af17d434d2efe62ac0818cba284cc0e03d2bc": true,
		"5155bdff11442ba5c98ef0f4dac7ed44e2d19044de87944791064a5baddf8ee2": true,
		"6423ba4d6f33283bba3ac6a2d6754f0c98834d6abe1265ea5e59ecd09ac7255b": true,
		"887dfc1ed552a9cde3d205a08c0060c91f3bf627f056e561bdc604e97c47ae2f": true,
		"fa5adb8581d3b8a0eb64ddd9f891e31b9a1cc59ee5b010521488158827eed0b8": true,
		"07d0a66bd5b05797d2c9a70791e42c1a30d6a9645a25efcba6dc6bd7d3b06be0": true,
		"33f41344055525169f2539a48ba9a42fb5a925308ce5c5412fe03dcd703aad62": true,
		"f4e04c67673fdf9e99c78246b6260270e674a64a2f7c294530d518fb904b8aae": true,
		"b1fed05c2d88dd733cfe31583c6e8fb72d33e1a78fa4ae3d456f2bad87d0c03e": true,
		"e4a5687ec341e1612b162f01ebb1c20f394b3edca28cc2ac1547d2c0fb92aff4": true,
		"d8e22fd9d4f3ddd2f702f9bba8904581a097bd7d2bdac228f7dbf76de642435b": true,
		"960b5199b4f5fe8387d59736d8565daae7c2017d24e8604c03eeed7b30db0c3e": true,
		"f492c42d001f62ccd610202e2e913200967ec1d07fb0b4b2775c3026c6eed9ea": true,
		"b2120a5183057ec8f009450b5726202b653fa61d665f72585cf1c6548759199e": true,
		"7afb727d67a50b7f5547172cd61c22de26835e886e2fa526045cbffbf33ddf1f": true,
		"f55b2765a57e3ce2082dd552e5ca5e4a2074e63e4c9675a9588e7ace335921bb": true,
		"2325114ba2114e22498500e99dd01df660d5b71647ac7945be7a879c91dccc6a": true,
		"ba2ce228ccd13b191bc931a858c3f4ccdd86cf5de3a031df45b9d2f7ee6b075e": true,
		"326ac7c9e77883614ff00ea647fedbe27d521c69041f92828b1cb0a03129ee88": true,
		"265449a27a185ae1487c2de8d43c63e15c4558a23e358be32ecd25eecf4ebe53": true,
		"d8723431ac2c27d87f6469b4f00415ec3613167d758b2e07195a85acfee99d55": true,
		"e4a6533905ebdb0e97a817b97976726f7f942512fc91dfe3087b7ed2cba76d53": true,
		"655df34bcd57361ab695a56ad0b898c06ca5db654a7dc7ca82daec4c939c0a1b": true,
		"acc4062a171fbe3281d438e785646b7be5b45bb1ab5de90d293bc40b27fea094": true,
		"dd5a37fec8e7dd694ffcea6e982706c14c25c505a0679ac97fdcef0c2f0d53c7": true,
		"70366a6aff2b87e5aced02b3144a2469c323ebb21382b8592d9e9fec513b6cb4": true,
		"9d5f214422716dbbefa1b66cea7fd4fcd80e37994f8f91791c638353511dec2c": true,
		"96075f3f66c05734df94efe821f5830c70c10bcc51a1cd17161d6f6722cfe0de": true,
		"4d964cb6b6ac2673541012b53f372711f7d844aebad0d44dad45ff9d690996c4": true,
		"eac44543714a457e12e6fed45878afdac77c80b5b77ff55019a3a8295ec93a55": true,
		"6f11a227f925986c2309854ad8c9947be3a6f7a7b5c149f1afc2809eb85c0702": true,
	}
)

func transactionForkHackCheck(hash crypto.Hash) bool {
	hs := hash.String()
	if hs == TransactionEmptyOutputsForkHack {
		return true
	}
	if hs == TransactionScriptThresholdForkHack {
		return true
	}
	return TransactionDepositOutputsForkHacks[hs]
}
