# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['onebone',
 'onebone.feature',
 'onebone.math',
 'onebone.preprocessing',
 'onebone.signal',
 'onebone.utils']

package_data = \
{'': ['*']}

install_requires = \
['PyWavelets>=1.3.0,<2.0.0',
 'numpy>=1.23.0,<2.0.0',
 'pandas>=1.4.3,<2.0.0',
 'scikit-learn>=1.2.2,<2.0.0',
 'scipy>=1.8.1,<2.0.0']

setup_kwargs = {
    'name': 'onebone',
    'version': '1.3.1',
    'description': 'An Open Source Signal Processing Library for Sensor Signals about vibration, current, etc.',
    'long_description': '<p align="center">\n<img src="https://user-images.githubusercontent.com/79968466/149683786-52ad7fc8-df64-4778-8381-35663c100c77.png" align="center" width="50%" alt="onepredict logo">\n\n[![Documentation Status](https://readthedocs.org/projects/onebone/badge/?version=latest)](https://onebone.readthedocs.io/?badge=latest)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black) <!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section --> [![All Contributors](https://img.shields.io/badge/all_contributors-9-orange.svg?style=flat-square)](#contributors-) <!-- ALL-CONTRIBUTORS-BADGE:END -->\n\n# Summary\n\n`onebone` is an open-source software for signal analysis about predictive maintenance, being used for research activities at [ⓒ ONEPREDICT Corp.](https://onepredict.ai/). It includes modules for preprocessing, health feature, and more. If you need to analyze signals for industrial equipments like turbines, a rotary machinery or componets like gears, bearings, give onebone a try!\n\nThe directory is as follows:\n\n```text\n.\n├── docs\n├── onebone\n│ ├── feature\n│ ├── math\n│ ├── preprocessing\n│ ├── signal\n│ └── utils\n├── tests\n├── tools\n├── README.md\n├── Makefile\n└── pyproject.toml\n```\n\n## Documentation\n\n<!--TODO: Changes the documentation link to public accessible link.-->\n<!--TODO: Add the reference for modules like this link(https://numpy.org/doc/stable/reference/index.html)-->\n\nThis reference manual details functions included in onebone, describing what they are and what they do. For learning how to use onebone, see the complete [documentation](https://onebone.readthedocs.io/en/latest/).\n\n# Contributors ✨\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tr>\n    <td align="center"><a href="https://github.com/kyunghwan-onepredict"><img src="https://avatars.githubusercontent.com/u/86699249?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kyunghwan Kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=kyunghwan-onepredict" title="Code">💻</a> <a href="https://github.com/Onepredict/onebone/commits?author=kyunghwan-onepredict" title="Documentation">📖</a> <a href="https://github.com/Onepredict/onebone/pulls?q=is%3Apr+reviewed-by%3Akyunghwan-onepredict" title="Reviewed Pull Requests">👀</a></td>\n    <td align="center"><a href="https://github.com/Kangwhi-Kim"><img src="https://avatars.githubusercontent.com/u/79968466?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kangwhi Kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=Kangwhi-Kim" title="Code">💻</a> <a href="https://github.com/Onepredict/onebone/commits?author=Kangwhi-Kim" title="Documentation">📖</a> <a href="https://github.com/Onepredict/onebone/pulls?q=is%3Apr+reviewed-by%3AKangwhi-Kim" title="Reviewed Pull Requests">👀</a></td>\n    <td align="center"><a href="https://github.com/DaeyeopN"><img src="https://avatars.githubusercontent.com/u/80095250?v=4?s=100" width="100px;" alt=""/><br /><sub><b>DaeyeopN</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=DaeyeopN" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/isingmodel"><img src="https://avatars.githubusercontent.com/u/31462012?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kibum Fred Kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=isingmodel" title="Code">💻</a><a href="https://github.com/Onepredict/onebone/pulls?q=is%3Apr+reviewed-by%3Aisingmodel" title="Reviewed Pull Requests">👀</a></td>\n    <td align="center"><a href="https://github.com/kbpark-onepredict"><img src="https://avatars.githubusercontent.com/u/67666211?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kibum Park</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=kbpark-onepredict" title="Code">💻</a> <a href="https://github.com/Onepredict/onebone/pulls?q=is%3Apr+reviewed-by%3Akbpark-onepredict" title="Reviewed Pull Requests">👀</a></td>\n    <td align="center"><a href="https://github.com/seone-kim"><img src="https://avatars.githubusercontent.com/u/91518385?v=4?s=100" width="100px;" alt=""/><br /><sub><b>sewon.kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=seone-kim" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/jeonjuna"><img src="https://avatars.githubusercontent.com/u/88358071?v=4?s=100" width="100px;" alt=""/><br /><sub><b>jeonjuna</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=jeonjuna" title="Code">💻</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/akangel0307"><img src="https://avatars.githubusercontent.com/u/92007351?v=4?s=100" width="100px;" alt=""/><br /><sub><b>SunjinKim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=akangel0307" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/hjkim-onepredict"><img src="https://avatars.githubusercontent.com/u/67408278?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hyunjae Kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=hjkim-onepredict" title="Code">💻</a></td>\n  </tr>\n</table>\n\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n\n# Getting started\n\n## Prerequisite\n\nonebone requires Python 3.8+.\n\n## Installation\n\n<!--TODO: Register onebone on the pypi server.-->\n\nonebone can be installed via pip from [PyPI](https://pypi.org/project/onebone/)\n\n```bash\n$ pip install onebone\n```\n\nIt can be checked as follows whether the onebone has been installed.\n\n```python\n>>> import onebone\n>>> onebone.__version__\n```\n\n## Usage\n\nIt assumes that the user has already installed the onebone package.\n\nYou can import directly the function, for example:\n\n```python\n>>> from onebone.feature import tacho_to_rpm\n```\n\n# Call for contribute\n\nWe appreciate and welcome contributions. Small improvements or fixes are always appreciated; issues labeled as "good first issue" may be a good starting point.\n\nWriting code isn\'t the only way to contribute to onebone. You can also:\n\n- triage issues\n- review pull requests\n- help with outreach and onboard new contributors\n\nIf you\'re unsure where to start or how your skills fit in, reach out! You can ask here, on GitHub, by leaving a comment on a relevant issue that is already open.\n\nIf you want to use an code for signal analysis, but it\'s not in onebone, make a issue.\n\nPlease follow [this guide](https://github.com/Onepredict/onebone/blob/main/wiki/development_guide.md) to contribute to onebone.\n\nIf you are new to contributing to open source, [this guide](https://opensource.guide/how-to-contribute/) helps explain why, what, and how to get involved.\n\n# References\n\n- [Numpy](https://numpy.org/)\n- [Scipy](https://scipy.org/)\n- [Matlab](https://www.mathworks.com/help/index.html?s_tid=CRUX_lftnav)\n',
    'author': 'Kyunghwan Kim',
    'author_email': 'kyunghwan.kim@onepredict.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
