# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_yaz.ipynb.

# %% ../nbs/01_yaz.ipynb 3
from __future__ import annotations
from fastcore.docments import *
from fastcore.test import *
from fastcore.utils import *
from .utils import *

import pandas as pd
import numpy as np

from os.path import join
import pathlib
import pkg_resources
import os


# %% auto 0
__all__ = ['loadDataYaz']

# %% ../nbs/01_yaz.ipynb 5
def loadDataYaz(testDays = 7, daysToCut = 0, normalizeDemand = True, unstacked = False, returnXY = False):

    # LOAD DATA
    dataPath = pkg_resources.resource_stream(__name__, 'datasets/dataYaz_unprocessed.csv')
    data = pd.read_csv(dataPath)
    # dataPath = "/home/kagu/datasetsDynamic/datasetsDynamic/datasets/dataYaz_unprocessed.csv"
    # data = pd.read_csv(dataPath)

    # DAY INDEX
    data = data.reset_index().rename(columns = {'index': 'dayIndex'})
    data['dayIndex'] = data.dayIndex

    # SEPARATE DEMAND OF DIFFERENT ITEMS
    X = data.iloc[:, 0:11]
    y = data.iloc[:, 12:]

    dataList = list()
    for col in y.columns:
        X_temp = X
        X_temp["item"] = col
        y_temp = y[col]
        data_temp = pd.concat([X_temp, y_temp], axis=1)
        data_temp.rename(columns={col: "demand"}, inplace=True)
        dataList.append(data_temp)

    data = pd.concat(dataList, axis = 0)

    #---

    # ID FEATURE AND SORTING
    data['id'] = data['item']
    data = data.sort_values(by = ['id', 'dayIndex'], axis = 0).reset_index(drop = True)

    #---

    # CUT DAYS DEPENDING ON DAYSTOCUT
    cutOffDate = data.dayIndex.max() - daysToCut
    data = data[data['dayIndex'] <= cutOffDate].reset_index(drop = True)

    #---

    # LABEL
    if isinstance(testDays, int):
        nDaysTest = testDays
    else:
        tsSizes = data.groupby(['id']).size()
        nDaysTest = int(tsSizes.iloc[0] * testDays)

    cutoffDateTest = data.dayIndex.max() - nDaysTest
    data['label'] = ['train' if data.dayIndex.iloc[i] <= cutoffDateTest else 'test' for i in range(data.shape[0])]    

    #---

    # NORMALIZE DEMAND
    if normalizeDemand:
        scalingData = data[data.label == 'train'].groupby('id')['demand'].agg('max').reset_index()
        scalingData.rename(columns = {'demand': 'scalingValue'}, inplace = True)
        data = pd.merge(data, scalingData, on = 'id')

        data['demand'] = data.demand / data.scalingValue
    else:
        data['scalingValue'] = 1

    #---

    # DEMAND LAG FEATURES
    data = createLagFeatures(data = data, 
                            idFeature = 'id',
                            lagDays = range(1, 8), 
                            lagDaysArithmetic = [7, 14, 21, 28])

    #---
 
    # CREATE UNSTACKED MULTIDIMENSIONAL DEMAND VECTOR IF DESIRED
    
    X = data.drop(['demand'], axis = 1, inplace = False)
    y = data[['demand']]

    if unstacked:
        colsDemand = [column for column in X.columns if 'demand_' in column]
        colsOther = [column for column in X.columns if not 'demand_' in column]
        
        generalData = data[colsOther][data['id'] == X['id'][0]].reset_index(drop = True).drop(['id', 'scalingValue'], axis = 1)
        
        XList = list()
        yList = list()
        scalingValueList = list()
        
        XList.append(generalData)

        for item in np.unique(X['id']):
            XItem = X[X['id'] == item].reset_index(drop = True)
            yItem = y[X['id'] == item].reset_index(drop = True)

            newColNames = {col: col + '_' + item for col in colsDemand}
            
            XToAdd = XItem[colsDemand].rename(columns = newColNames)
            yToAdd = yItem.rename(columns = {'demand': 'demand_' + item})
            scalingValueToAdd = XItem[['scalingValue']].rename(columns = {'scalingValue': 'scalingValue_' + item})
            
            XList.append(XToAdd)
            yList.append(yToAdd)
            scalingValueList.append(scalingValueToAdd)
            
        X = pd.concat(XList, axis = 1)
        y = pd.concat(yList, axis = 1)
        scalingValues = pd.concat(scalingValueList, axis = 1)
        
        X = pd.concat([X, scalingValues], axis = 1)

    #---

    # DATE DUMMY VARIABLES
    X['year'] = X['year'].apply(lambda x: str(int(x)))

    dateDummies = pd.concat([pd.get_dummies(X.weekday, prefix = 'weekday'), 
                             pd.get_dummies(X.month, prefix = 'month'), 
                             pd.get_dummies(X.year, prefix = 'year')], axis = 1)

    itemDummies = pd.get_dummies(X.item, prefix = 'item')

    X = pd.concat([X, dateDummies, itemDummies], axis = 1).drop(['weekday', 'month', 'year', 'item'], axis = 1)

    #---

    # SPLIT INTO TRAIN AND TEST DATA
    if unstacked:
        XArray = np.array(X.drop(['label'], axis = 1))
        yArray = np.array(y)          
    else:
        XArray = np.array(X.drop(['label', 'id'], axis = 1))
        yArray = np.ravel(y)    


    XTrain = XArray[X['label'] == 'train']
    yTrain = yArray[X['label'] == 'train']

    XTest = XArray[X['label'] == 'test']
    yTest = yArray[X['label'] == 'test']

    data = pd.concat([y, X], axis = 1)

    #---

    if not normalizeDemand:
        
        if unstacked:
            colsScalingValue = [column for column in X.columns if 'scalingValue' in column]
            data.drop(colsScalingValue, axis = 1)
            X.drop(colsScalingValue, axis = 1)
            
        else:
            data = data.drop(['scalingValue'], axis = 1)
            X = X.drop(['scalingValue'], axis = 1)

    if returnXY:
        return data, XTrain, yTrain, XTest, yTest
    else:
        return data    
