#! /usr/bin/env python3
# -*- coding: utf-8 -*-
# @Time    : 2022-06-16 10:07
# @Site    :
# @File    : dealFile.py
# @Software: PyCharm
import os

import openpyxl as op

def save_excel(save_path: str, fileName: str, data: list,sheet_name='Sheet',append=False):
    """
    :param save_path: 路径
    :param fileName: 文件名（不包含后缀）
    :param data: ex:[{"id": 1, "name": "立智", "price": 100}, {"id": 2, "name": "维纳", "price": 200},{"id": 3, "name": "如家", "price": 300}]
    :param sheet_name: sheet名
    :param append: 追加写入
    :return:
    """

    if append:
        fileName = f"{save_path}/{fileName}.xlsx"
        assert os.path.isfile(fileName), f"{fileName} 文件不存在"
        wb = op.load_workbook(fileName)  # 创建工作簿对象
        ws = wb[sheet_name]  # 创建子表
        append_sheet = wb.copy_worksheet(ws)
        rows = append_sheet.max_row
        for row in range(rows + 1, rows + len(data) + 1):
            i = 1
            for l in range(1, len(data[0])+1):
                ws.cell(row, l, list(data[i].values())[l-1])
            i += 1
    else:
        fileName = f"{save_path}/{fileName}.xlsx"
        wb = op.Workbook()  # 创建工作簿对象
        ws = wb['Sheet']  # 创建子表
        title = list(data[0].keys())  # 设置表头
        ws.append(title)  # 添加表头
        for i in range(len(data)):
            d = list(data[i].values())
            ws.append(d)  # 每次写入一行
    wb.save(fileName)


def read_excel(path: str, sheet: str):
    """读取excel"""
    # 打开工作簿
    workbook = op.load_workbook(path)
    # 获取表单
    sheet = workbook[sheet]
    # 获取最大行数
    max_row = sheet.max_row
    # 获取最大列数
    max_column = sheet.max_column
    lr = tuple([tuple([sheet.cell(row=row, column=column).value for column in range(1, max_column+1)]) for row in range(1, max_row+1)])
    print(lr)
    return lr


if __name__ == '__main__':
    testData = [{'表名': 'jd_account_list', '列名': 'id', '数据类型': 'int(64)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'platform', '数据类型': 'varchar(64)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平台', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'user_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'shop_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'shop id', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'account_name', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户名', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'passwd', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'passwd', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'brand', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '品牌', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'cookie', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'cookie', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'cookie_update', '数据类型': 'int(6)', '主键': None, '是否可为空': 'YES', '默认值': '0', '备注': '是否重新登录，1登录，0不登录', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'create_time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'YES', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_list', '列名': 'flag', '数据类型': 'int(6)', '主键': None, '是否可为空': 'YES', '默认值': '1', '备注': '1账户正常采集，0账户停止所有采集', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '账户报表', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'mobile_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广设备', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'depth_passenger_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '深度进店数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'platform_gmv', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'pin_id', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户id', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'preorder_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'department_gmv', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户名称 ', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'visit_page_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '访问页面数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'visit_time_average', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '页面平均访问时长', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'visitor_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '广告访客数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'channel_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'coupon_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '领劵数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI ', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'new_customers_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '下单新客数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'platform_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'goods_attention_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '商品关注数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'cpa', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'CPA 新', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '\t点击量', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'department_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'shop_attention_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺关注数', '数据库': 'zein'}, {'表名': 'jd_account_statement', '列名': 'order_date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '数据报表-效果报表-地域效果总揽', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'platform_gmv', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'click_date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '周期', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'department_gmv', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'mapped_area_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'mapped_area_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '省/直辖市', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'channel_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI ', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'platform_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击量', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'department_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_area_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '普通计划-创意效果', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'unique_value', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '数据更新批次，每次更新多个表关联值，按照时间排序取出该字段，可以从所有关联表中取出最新值', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'item_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '定向方式', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'put_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'material_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '单元id', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'custom_title', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '创意名称', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'sub_exp_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'campaign_strategy_status', '数据类型': 'varchar(12)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'size_str', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '创意图片尺寸', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'activity_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'delivery_version', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'exp_end_time', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'stick_modified_time', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'sku_state', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'sku_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'height', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'flag_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'material_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'ad_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'ad_creative_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'stick_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'stick_exist', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'tmm_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'group_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'exp_start_time', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'ad_helper_group_id', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'custom_flag', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'start_time', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'stick_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'exp_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'campaign_flag', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'ad_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广创意', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'promo_pos', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'campaign_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'url', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'img_url', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'ctr', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'cpm', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'effect_order_sum', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_auction_margin_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'effect_cart_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'direct_auction_margin_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'effect_order_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单行', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_order_roi', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'indirect_auction_margin_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'effect_auction_margin_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'material_size', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'indirect_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'cpa', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'CPA 新', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总预售订单数', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击量', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'effect_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_create_effect', '列名': 'direct_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '账户报表-创意报表', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'ad_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '单元id', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'mobile_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广设备', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划名称', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'item_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'depth_passenger_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'platform_gmv', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'preorder_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'department_gmv', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'visit_page_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '访问页面数', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'visit_time_average', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '页面平均访问时长', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'visitor_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '广告访客数', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'channel_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'coupon_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '领劵数', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI ', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'new_customers_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '下单新客数', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'ad_visitor_cnt_for_internal_summary', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'platform_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'goods_attention_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '商品关注数', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'cpa', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'CPA 新', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '\t点击量', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'department_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_creative_report', '列名': 'shop_attention_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺关注数', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '普通计划-溢价人群 效果', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'unique_value', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '数据更新批次，每次更新多个表关联值，按照时间排序取出该字段，可以从所有关联表中取出最新值', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'put_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'dmp_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '人群名称', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'effect_cart_cnt', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '人群名称', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'click_date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'dmp_exist', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '人群名称', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'stick_modified_time', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '最后修改时间', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'dmp_crowd_auto_pk', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'dmp_create_time', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划类型', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广计划', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'stick_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'dmp_id', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'stick_exist', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'group_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'effect_order_sum', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'display_type_code', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'dmp_status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'stick_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'effect_order_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'premium_orientation_range', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'campaign_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'remain_time', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'dmp_factor', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单行', '数据库': 'zein'}, {'表名': 'jd_crowd_premium_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击数', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '账户报表-商品定向报表', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划名称', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'sku_name', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '商品', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'sku_cname3', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '类目', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'price_grades_str', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '价格', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'group_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'sku_brand_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'click_date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户名称 ', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'product_delivery_matching_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'total_presale_order_sum', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'sku_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'product_delivery_matching_id', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'sku_cid3', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'sku_brand_name_cn', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '品牌', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'ad_name', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广创意', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI ', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'delivery_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'mobile_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广设备', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'product_delivery_matching_combination', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'group_name', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'ad_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '\t点击量', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_delivery_report', '列名': 'price_grades', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '推广管理-普通计划-每一个计划-每一个单元-单元推广设置-定向设置-关键词定向-添加关键词-效果推词/商品推词/核心拓词', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'keyword_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '关键词类型', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'group_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'campaign_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'campaign_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'sku_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'key_word', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '关键词', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'pv', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '搜索量', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'avg_big_price', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均出价', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'purchased_key_word_num', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'source_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'star_count', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推荐购买热度', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'min_bid_price', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'ctr', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率%', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'cvr', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率%', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'suggested_bid_price', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'key_word_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_list', '列名': 'sid', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '普通计划-《关键词-普通计划》效果', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'unique_value', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '数据更新批次，每次更新多个表关联值，按照时间排序取出该字段，可以从所有关联表中取出最新值', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'keyword_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '关键词名称', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'put_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_ctr', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_clicks', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'effect_cart_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_impressions', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'click_date', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'search_promote_rank_success_rate', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'average_history_rank_expand', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_total_cart_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'stick_modified_time', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '最后修改时间', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'create_id', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ID', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'new_pc_rank', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'new_current_pc_showq', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_ctr', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划类型', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'edit', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'search_promote_rank_coef', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_total_order_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_total_order_sum', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'search_promote_rank_enable', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'keyword_wl_price_source', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'new_wl_rank', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'stick_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_cpc', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'stick_exist', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_total_cart_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'group_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_roi', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'keyword_value', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '关键词', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'search_promote_rank_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'keyword_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_cvs', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'effect_order_sum', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'ad_helper_group_id', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_total_order_sum', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'keyword_wl_price', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'new_current_wl_showq', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'stick_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'is_default_price', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'keyword_pc_price', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'effect_order_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'keyword_flag', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'campaign_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_impressions', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_cvs', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_cpc', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单行', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击数', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_clicks', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'keyword_yn', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_roi', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划名', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'ad_helper_group_name', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_failed_cost', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_plan_effect', '列名': 'grab_success_cost', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '关键词普通计划-任一关键词-修改出价-无线端最终出价建议', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'unique_value', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '数据更新批次，每次更新多个表关联值，按照时间排序取出该字段，可以从所有关联表中取出最新值', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划名', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划类型', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '单元', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'keyword', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '关键词', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'date_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'hourHigh:今日出价高值 hourMiddle:今日出价中值  hourLow:今日出价中值低值 dayHigh:近七天高值  dayMiddle:近七天中值  dayLow:近七天低值', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'breakpoint', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '时间点', '数据库': 'zein'}, {'表名': 'jd_keyword_recommended_price', '列名': 'price', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '出价', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '账户报表-关键词报表', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'keyword_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '关键词', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'click_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'targeting_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI ', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '\t点击量', '数据库': 'zein'}, {'表名': 'jd_keyword_report', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '普通计划-计划效果', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'unique_value', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '状态 2：有效 1：暂停', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'cpa', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'CPA 新', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单行', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击数', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'campaign_name', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划名', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'auto_flag', '数据类型': 'varchar(6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'put_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'campaign_strategy_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'effect_cart_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'click_date', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'activity_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户名称 ', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'delivery_version', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'stick_modified_time', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '最后修改时间', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'budget', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日预算', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'time_range', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '时段', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'direct_auction_margin_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划类型', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'active', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'price_coef', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '实时折扣系数', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'stick_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'stick_exist', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'tmm_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'effect_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'effect_order_sum', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'ad_helper_group_id', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'total_auction_margin_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'time_range_price_coef', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '分时折扣', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'start_time', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '开始有效期', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'end_time', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '结束有效期', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'stick_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'campaign_flag', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'effect_order_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'campaign_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'indirect_auction_margin_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'effect_auction_margin_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'indirect_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'activity_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'direct_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_plan_effect', '列名': 'ad_helper_group_name', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '账户报表-推广计划报表', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划名称', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'put_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '类型', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'mobile_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广设备', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'depth_passenger_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '深度进店数', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'preorder_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'click_date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户名称 ', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'visit_page_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '访问页面数', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'visit_time_average', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '页面平均访问时长', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'visitor_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '广告访客数', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'campaign_put_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'coupon_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '领劵数', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI ', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'new_customers_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '下单新客数', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'goods_attention_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '商品关注数', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'cpa', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'CPA 新', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '\t点击量', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_promotion_plan_report', '列名': 'shop_attention_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺关注数', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '数据报表-效果报表-搜索词效果总揽', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'keyword_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '关键词', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'platform_gmv', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'pin_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'click_date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'search_term', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '搜索词', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'department_gmv', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'channel_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'ad_name', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广创意', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'platform_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'impressions', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单行', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击量', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'department_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_search_word_effect', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广计划', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '数据报表-效果报表-商品定向效果总揽', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'sku_c_name3', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '类目名称', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'sku_price', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'product_delivery_trigger_sku_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'sku', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'click_date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'sku_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'sku', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划类型', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'ad_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广创意id', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'sku_url', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'sku_brand_id', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'sku_name', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '商品/类目', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'product_delivery_matching_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '匹配类型 5：搭配商品定向  4：相似商品定向 3:类目匹配  2：spu匹配 1：SKU匹配', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'product_delivery_matching_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'sku_cid3', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '类目ID', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'sku_brand_name_cn', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '品牌', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'ad_name', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广创意', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'delivery_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'mobile_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '品牌', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'product_delivery_matching_combination', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单行', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击量', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'price_grades', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_total_unit_orientation_effect', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广计划', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '普通计划-单元效果', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'unique_value', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'automated_bidding_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'auto_flag', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'put_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'search_fee', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '单元id', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'ad_helper_group_id', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'sub_exp_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'recommend_fee', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'campaign_strategy_status', '数据类型': 'varchar(12)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'delivery_target', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'activity_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'delivery_version', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'stick_modified_time', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'coupon_status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'stick_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'exp_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'campaign_flag', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'trace_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'premium_orientation_range', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'bidding_control_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'campaign_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'new_area_id', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'flag_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'group_tcpa_max_click_bid', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划名称', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'stick_exist', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'crowd_valid_status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'group_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'activity_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'device', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'exp_id_value', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'item_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '定向方式', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'ctr', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'cpm', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'automated_bidding_type_unit', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '出价方式 智能调价：2 、 成本控制：1、 预算控制：256、 手动出价：0', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'tcpa_status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'effect_cart_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'bidding_target', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '出价', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'cpa_guarantee_status_msg', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'm_c_state', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'direct_auction_margin_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'bidding_control_type_unit', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_order_roi', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'tcpa_bid', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '目标成交成本', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'warning_message', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'bidding_type_filter', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'group_tcpa_max_click_bid_unit', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'mobile_price_coef', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'effect_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'group_area_expand', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'fee_expand', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'descs', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'effect_order_sum', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_auction_margin_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'ecpc_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'premium_coef', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'tcpa_phase', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'auto_bid_target', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '出价', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'tcpa_mode', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'group_day_cost', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单行', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'indirect_auction_margin_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'effect_auction_margin_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'indirect_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'cpa', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'CPA 新', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'cpa_guarantee_status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总预售订单数', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击量', '数据库': 'zein'}, {'表名': 'jd_unit_effect', '列名': 'direct_auction_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '普通计划-商品定向效果', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'unique_value', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '数据更新批次，每次更新多个表关联值，按照时间排序取出该字段，可以从所有关联表中取出最新值', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'start_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'end_date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'sku_c_name3', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '类目名称', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'effect_cart_cnt', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '人群名称', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'click_date', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'stick_modified_time', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '最后修改时间', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'product_status_flag', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'wl_price', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '出价', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'sku_id', '数据类型': 'bigint(20)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'sku', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划类型', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'stick_status', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'stick_exist', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'group_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'matching_id_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'effect_order_sum', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'price_grades_str', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '价格', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'sku_brand_id', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'pc_price', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '出价', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'sku_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '商品/类目', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'product_delivery_matching_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '匹配类型 5：搭配商品定向  4：相似商品定向 3:类目匹配  2：spu匹配 1：SKU匹配', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'category_price_grade', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '价格', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'wl_price_source', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'stick_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'is_default_price', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'product_delivery_matching_id', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'effect_order_cnt', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'sku_cid3', '数据类型': 'int(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '类目ID', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'sku_brand_name_cn', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '品牌', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'campaign_exist', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'delivery_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'product_status', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单行', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击量', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'price_grades', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'business_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广计划', '数据库': 'zein'}, {'表名': 'jd_unit_orientation_effect', '列名': 'sku_url', '数据类型': 'longtext', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'id', '数据类型': 'int(6)', '主键': 'YES', '是否可为空': 'NO', '默认值': None, '备注': '账户报表-推广单元报表', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'time', '数据类型': 'timestamp', '主键': None, '是否可为空': 'NO', '默认值': 'CURRENT_TIMESTAMP', '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'shop_id', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺id', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'shop', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '所属店铺', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'date', '数据类型': 'datetime', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '日期', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'campaign_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划名称', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'campaign_type', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划类型', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'campaign_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '计划id', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'group_id', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '单元id', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'mobile_type', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广设备', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'group_name', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '推广单元', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'pin', '数据类型': 'varchar(255)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '账户名称 ', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'department_gmv', '数据类型': 'double(128,2)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'item_type', '数据类型': 'varchar(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'ctr', '数据类型': 'double(128,6)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '点击率(%)', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'depth_passenger_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'cpm', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '千次展现成本', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'presale_indirect_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'presale_direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单量', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'preorder_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单行', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'direct_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单行', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'indirect_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接加购数 ', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'visit_page_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '访问页面数', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'visit_time_average', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '页面平均访问时长', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'total_presale_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'direct_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接加购数 ', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'visitor_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '广告访客数', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'cost', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总费用 ', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'coupon_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '领劵数', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'total_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'total_cart_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总加购数', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'presale_indirect_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'total_order_roi', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'ROI ', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'new_customers_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '下单新客数', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'impressions', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '展现数', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'indirect_order_sum', '数据类型': 'double(255,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '间接订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '直接订单金额 ', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'goods_attention_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '商品关注数', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'total_order_cvs', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '转化率(%)', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'cpa', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': 'CPA 新', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'cpc', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '平均点击成本', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'total_presale_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'presale_direct_order_sum', '数据类型': 'double(128,4)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '预售订单金额', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'clicks', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '\t点击量', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'total_order_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '总订单行', '数据库': 'zein'}, {'表名': 'jd_unit_report', '列名': 'shop_attention_cnt', '数据类型': 'int(128)', '主键': None, '是否可为空': 'YES', '默认值': None, '备注': '店铺关注数', '数据库': 'zein'}]


    fileName = '测试4'

    save_excel('./', fileName, testData)
    # read_excel('./测试3.xlsx','Sheet')
