# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_tabelas_fipe.ipynb.

# %% auto 0
__all__ = ['base_url', 'consulta_tabela_referencia', 'consulta_tabela_marcas', 'consulta_tabela_modelos']

# %% ../nbs/01_tabelas_fipe.ipynb 3
import os
import json
import requests
import pandas as pd

base_url = "http://veiculos.fipe.org.br/api/veiculos/"

def consulta_tabela_referencia():
        url = f"{base_url}/ConsultarTabelaDeReferencia"
        req = requests.post(url)
        req_text = req.text
        req_json = json.loads(req_text)
        df = pd.DataFrame(req_json)
        df.columns = ['codigo_mes', 'mes']
        df['mes'] = df['mes'].str.strip()
        return df

def consulta_tabela_marcas(mes='agosto/2022', tipo_veiculo='carro'):
        url = f"{base_url}/ConsultarMarcas"

        tabela_referencia = consulta_tabela_referencia()
        codigo_tabela_referencia = int(tabela_referencia.query(f"mes == '{mes}'").loc[:,'codigo_mes'].values[0])

        tipos_veiculos = {'carro': 1, 'moto': 2, 'caminhao': 3}
        codigo_tipo_veiculo = tipos_veiculos[tipo_veiculo]

        body = {"codigoTabelaReferencia": codigo_tabela_referencia, "codigoTipoVeiculo": codigo_tipo_veiculo}
        req = requests.post(url, data=body)
        req_text = req.text
        req_json = json.loads(req_text)
        df = pd.DataFrame(req_json).rename(columns={'Label': 'marca', 'Value': 'codigo_marca'})
        df['mes'] = mes

        return df

def consulta_tabela_modelos(mes='agosto/2022', tipo_veiculo='carro', codigo_marca=59):
        url = f"{base_url}/ConsultarModelos"
        tabela_referencia = consulta_tabela_referencia()
        codigo_tabela_referencia = int(tabela_referencia.query(f"mes == '{mes}'").loc[:,'codigo_mes'].values[0])

        tipos_veiculos = {'carro': 1, 'moto': 2, 'caminhao': 3}
        codigo_tipo_veiculo = tipos_veiculos[tipo_veiculo]

        body = {"codigoTabelaReferencia": codigo_tabela_referencia,
                "codigoTipoVeiculo": codigo_tipo_veiculo,
                "codigoMarca": codigo_marca}
        req = requests.post(url, data=body)
        req_text = req.text
        req_json = json.loads(req_text)
        df = pd.DataFrame(req_json['Modelos']).rename(columns={'Label': 'modelo', 'Value': 'codigo_modelo'})
        return df
