"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const core = require("aws-cdk-lib");
const cognito = require("aws-cdk-lib/aws-cognito");
const index_1 = require("../src/index");
class IntegTesting {
    constructor() {
        const app = new core.App();
        const stack = new core.Stack(app, 'PrivateAssetBucket-stack2', {
            env: {
                account: '981237193288',
                region: 'us-east-1',
            },
        });
        const userPool = new cognito.UserPool(stack, 'userPool', {
            removalPolicy: core.RemovalPolicy.DESTROY,
        });
        const userPoolWebClient = new cognito.UserPoolClient(stack, 'userPoolWebClient', {
            userPool: userPool,
            generateSecret: false,
            preventUserExistenceErrors: true,
            authFlows: {
                adminUserPassword: true,
                userPassword: true,
            },
            oAuth: {
                flows: {
                    authorizationCodeGrant: false,
                    implicitCodeGrant: true,
                },
            },
        });
        const privateAssetBucket = new index_1.PrivateAssetBucket(stack, 'privateAssetBucket', {
            userPoolId: userPool.userPoolId,
            userPoolClientId: userPoolWebClient.userPoolClientId,
            tokenUse: 'access',
        });
        new core.CfnOutput(stack, 'AssetBucketName', {
            value: privateAssetBucket.assetBucketName,
        });
        new core.CfnOutput(stack, 'AssetBucketCloudfrontUrl', {
            value: privateAssetBucket.assetBucketCloudfrontUrl,
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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