/** JSON type */
export declare type Json = null | string | number | boolean | Json[] | JsonObject;
/** JSON Object type */
export declare type JsonObject = {
    [name: string]: Json;
};
/**
 * Check if a piece of JSON is a JSON object, and not e.g. a mere string or null
 *
 * @param j - the JSON
 */
export declare function isJsonObject(j: Json): j is JsonObject;
/**
 * Parse a string as JSON, while removing __proto__ and constructor, so JS prototype pollution is prevented
 *
 * @param s - the string to JSON parse
 */
export declare function safeJsonParse(s: string): Json;
