JOB_MANAGER_ABI = [
  { "inputs": [], "stateMutability": "nonpayable", "type": "constructor" },
  { "inputs": [], "name": "AccessControlBadConfirmation", "type": "error" },
  {
    "inputs": [
      { "internalType": "address", "name": "account", "type": "address" },
      { "internalType": "bytes32", "name": "neededRole", "type": "bytes32" },
    ],
    "name": "AccessControlUnauthorizedAccount",
    "type": "error",
  },
  {
    "inputs": [{ "internalType": "address", "name": "target", "type": "address" }],
    "name": "AddressEmptyCode",
    "type": "error",
  },
  {
    "inputs": [
      { "internalType": "address", "name": "implementation", "type": "address" },
    ],
    "name": "ERC1967InvalidImplementation",
    "type": "error",
  },
  { "inputs": [], "name": "ERC1967NonPayable", "type": "error" },
  { "inputs": [], "name": "FailedInnerCall", "type": "error" },
  { "inputs": [], "name": "InvalidInitialization", "type": "error" },
  { "inputs": [], "name": "NotInitializing", "type": "error" },
  { "inputs": [], "name": "ReentrancyGuardReentrantCall", "type": "error" },
  { "inputs": [], "name": "UUPSUnauthorizedCallContext", "type": "error" },
  {
    "inputs": [{ "internalType": "bytes32", "name": "slot", "type": "bytes32" }],
    "name": "UUPSUnsupportedProxiableUUID",
    "type": "error",
  },
  {
    "anonymous": False,
    "inputs": [
      {
        "indexed": True,
        "internalType": "uint256",
        "name": "jobId",
        "type": "uint256",
      },
      {
        "indexed": False,
        "internalType": "uint256",
        "name": "newBudget",
        "type": "uint256",
      },
    ],
    "name": "BudgetSet",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      {
        "indexed": False,
        "internalType": "uint64",
        "name": "version",
        "type": "uint64",
      },
    ],
    "name": "Initialized",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      {
        "indexed": True,
        "internalType": "uint256",
        "name": "jobId",
        "type": "uint256",
      },
      {
        "indexed": True,
        "internalType": "uint256",
        "name": "accountId",
        "type": "uint256",
      },
      {
        "indexed": True,
        "internalType": "address",
        "name": "client",
        "type": "address",
      },
      {
        "indexed": False,
        "internalType": "address",
        "name": "provider",
        "type": "address",
      },
      {
        "indexed": False,
        "internalType": "address",
        "name": "evaluator",
        "type": "address",
      },
      {
        "indexed": False,
        "internalType": "uint256",
        "name": "expiredAt",
        "type": "uint256",
      },
    ],
    "name": "JobCreated",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      {
        "indexed": True,
        "internalType": "uint256",
        "name": "jobId",
        "type": "uint256",
      },
      {
        "indexed": True,
        "internalType": "address",
        "name": "paymentToken",
        "type": "address",
      },
      {
        "indexed": False,
        "internalType": "uint256",
        "name": "newBudget",
        "type": "uint256",
      },
    ],
    "name": "JobPaymentTokenSet",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      {
        "indexed": True,
        "internalType": "uint256",
        "name": "jobId",
        "type": "uint256",
      },
      {
        "indexed": False,
        "internalType": "enum ACPTypes.JobPhase",
        "name": "oldPhase",
        "type": "uint8",
      },
      {
        "indexed": False,
        "internalType": "enum ACPTypes.JobPhase",
        "name": "newPhase",
        "type": "uint8",
      },
    ],
    "name": "JobPhaseUpdated",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      { "indexed": True, "internalType": "bytes32", "name": "role", "type": "bytes32" },
      {
        "indexed": True,
        "internalType": "bytes32",
        "name": "previousAdminRole",
        "type": "bytes32",
      },
      {
        "indexed": True,
        "internalType": "bytes32",
        "name": "newAdminRole",
        "type": "bytes32",
      },
    ],
    "name": "RoleAdminChanged",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      { "indexed": True, "internalType": "bytes32", "name": "role", "type": "bytes32" },
      {
        "indexed": True,
        "internalType": "address",
        "name": "account",
        "type": "address",
      },
      {
        "indexed": True,
        "internalType": "address",
        "name": "sender",
        "type": "address",
      },
    ],
    "name": "RoleGranted",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      { "indexed": True, "internalType": "bytes32", "name": "role", "type": "bytes32" },
      {
        "indexed": True,
        "internalType": "address",
        "name": "account",
        "type": "address",
      },
      {
        "indexed": True,
        "internalType": "address",
        "name": "sender",
        "type": "address",
      },
    ],
    "name": "RoleRevoked",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      {
        "indexed": True,
        "internalType": "address",
        "name": "implementation",
        "type": "address",
      },
    ],
    "name": "Upgraded",
    "type": "event",
  },
  {
    "anonymous": False,
    "inputs": [
      {
        "indexed": True,
        "internalType": "uint256",
        "name": "jobId",
        "type": "uint256",
      },
    ],
    "name": "X402PaymentReceived",
    "type": "event",
  },
  {
    "inputs": [],
    "name": "ACP_CONTRACT_ROLE",
    "outputs": [{ "internalType": "bytes32", "name": "", "type": "bytes32" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "ADMIN_ROLE",
    "outputs": [{ "internalType": "bytes32", "name": "", "type": "bytes32" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "DEFAULT_ADMIN_ROLE",
    "outputs": [{ "internalType": "bytes32", "name": "", "type": "bytes32" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "MEMO_MANAGER_ROLE",
    "outputs": [{ "internalType": "bytes32", "name": "", "type": "bytes32" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "UPGRADE_INTERFACE_VERSION",
    "outputs": [{ "internalType": "string", "name": "", "type": "string" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "X402_MANAGER_ROLE",
    "outputs": [{ "internalType": "bytes32", "name": "", "type": "bytes32" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "uint256", "name": "", "type": "uint256" },
      { "internalType": "uint256", "name": "", "type": "uint256" },
    ],
    "name": "accountJobs",
    "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "acpContract",
    "outputs": [{ "internalType": "address", "name": "", "type": "address" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "uint256", "name": "jobId", "type": "uint256" },
      { "internalType": "address", "name": "user", "type": "address" },
    ],
    "name": "canModifyJob",
    "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [{ "internalType": "uint256", "name": "jobId", "type": "uint256" }],
    "name": "confirmX402PaymentReceived",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "uint256", "name": "accountId", "type": "uint256" },
      { "internalType": "address", "name": "client", "type": "address" },
      { "internalType": "address", "name": "provider", "type": "address" },
      { "internalType": "address", "name": "evaluator", "type": "address" },
      { "internalType": "address", "name": "creator", "type": "address" },
      { "internalType": "uint256", "name": "budget", "type": "uint256" },
      {
        "internalType": "contract IERC20",
        "name": "paymentToken",
        "type": "address",
      },
      { "internalType": "uint256", "name": "expiredAt", "type": "uint256" },
    ],
    "name": "createJob",
    "outputs": [{ "internalType": "uint256", "name": "jobId", "type": "uint256" }],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "uint256", "name": "accountId", "type": "uint256" },
      { "internalType": "address", "name": "client", "type": "address" },
      { "internalType": "address", "name": "provider", "type": "address" },
      { "internalType": "address", "name": "evaluator", "type": "address" },
      { "internalType": "address", "name": "creator", "type": "address" },
      { "internalType": "uint256", "name": "budget", "type": "uint256" },
      {
        "internalType": "contract IERC20",
        "name": "paymentToken",
        "type": "address",
      },
      { "internalType": "uint256", "name": "expiredAt", "type": "uint256" },
    ],
    "name": "createJobWithX402",
    "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "uint256", "name": "accountId", "type": "uint256" },
      { "internalType": "uint256", "name": "offset", "type": "uint256" },
      { "internalType": "uint256", "name": "limit", "type": "uint256" },
    ],
    "name": "getAccountJobs",
    "outputs": [
      {
        "components": [
          { "internalType": "uint256", "name": "id", "type": "uint256" },
          { "internalType": "uint256", "name": "accountId", "type": "uint256" },
          { "internalType": "address", "name": "client", "type": "address" },
          { "internalType": "address", "name": "provider", "type": "address" },
          { "internalType": "address", "name": "evaluator", "type": "address" },
          { "internalType": "address", "name": "creator", "type": "address" },
          { "internalType": "uint256", "name": "budget", "type": "uint256" },
          {
            "internalType": "contract IERC20",
            "name": "jobPaymentToken",
            "type": "address",
          },
          {
            "internalType": "enum ACPTypes.JobPhase",
            "name": "phase",
            "type": "uint8",
          },
          { "internalType": "uint256", "name": "expiredAt", "type": "uint256" },
          { "internalType": "uint256", "name": "createdAt", "type": "uint256" },
          { "internalType": "uint256", "name": "memoCount", "type": "uint256" },
          { "internalType": "string", "name": "metadata", "type": "string" },
          { "internalType": "uint256", "name": "amountClaimed", "type": "uint256" },
        ],
        "internalType": "struct ACPTypes.Job[]",
        "name": "jobArray",
        "type": "tuple[]",
      },
      { "internalType": "uint256", "name": "total", "type": "uint256" },
    ],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [{ "internalType": "uint256", "name": "jobId", "type": "uint256" }],
    "name": "getJob",
    "outputs": [
      {
        "components": [
          { "internalType": "uint256", "name": "id", "type": "uint256" },
          { "internalType": "uint256", "name": "accountId", "type": "uint256" },
          { "internalType": "address", "name": "client", "type": "address" },
          { "internalType": "address", "name": "provider", "type": "address" },
          { "internalType": "address", "name": "evaluator", "type": "address" },
          { "internalType": "address", "name": "creator", "type": "address" },
          { "internalType": "uint256", "name": "budget", "type": "uint256" },
          {
            "internalType": "contract IERC20",
            "name": "jobPaymentToken",
            "type": "address",
          },
          {
            "internalType": "enum ACPTypes.JobPhase",
            "name": "phase",
            "type": "uint8",
          },
          { "internalType": "uint256", "name": "expiredAt", "type": "uint256" },
          { "internalType": "uint256", "name": "createdAt", "type": "uint256" },
          { "internalType": "uint256", "name": "memoCount", "type": "uint256" },
          { "internalType": "string", "name": "metadata", "type": "string" },
          { "internalType": "uint256", "name": "amountClaimed", "type": "uint256" },
        ],
        "internalType": "struct ACPTypes.Job",
        "name": "",
        "type": "tuple",
      },
    ],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [{ "internalType": "bytes32", "name": "role", "type": "bytes32" }],
    "name": "getRoleAdmin",
    "outputs": [{ "internalType": "bytes32", "name": "", "type": "bytes32" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "address", "name": "assignee", "type": "address" },
      { "internalType": "uint256", "name": "offset", "type": "uint256" },
      { "internalType": "uint256", "name": "limit", "type": "uint256" },
    ],
    "name": "getUserJobs",
    "outputs": [
      {
        "components": [
          { "internalType": "uint256", "name": "id", "type": "uint256" },
          { "internalType": "uint256", "name": "accountId", "type": "uint256" },
          { "internalType": "address", "name": "client", "type": "address" },
          { "internalType": "address", "name": "provider", "type": "address" },
          { "internalType": "address", "name": "evaluator", "type": "address" },
          { "internalType": "address", "name": "creator", "type": "address" },
          { "internalType": "uint256", "name": "budget", "type": "uint256" },
          {
            "internalType": "contract IERC20",
            "name": "jobPaymentToken",
            "type": "address",
          },
          {
            "internalType": "enum ACPTypes.JobPhase",
            "name": "phase",
            "type": "uint8",
          },
          { "internalType": "uint256", "name": "expiredAt", "type": "uint256" },
          { "internalType": "uint256", "name": "createdAt", "type": "uint256" },
          { "internalType": "uint256", "name": "memoCount", "type": "uint256" },
          { "internalType": "string", "name": "metadata", "type": "string" },
          { "internalType": "uint256", "name": "amountClaimed", "type": "uint256" },
        ],
        "internalType": "struct ACPTypes.Job[]",
        "name": "jobArray",
        "type": "tuple[]",
      },
      { "internalType": "uint256", "name": "total", "type": "uint256" },
    ],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [{ "internalType": "uint256", "name": "jobId", "type": "uint256" }],
    "name": "getX402PaymentDetails",
    "outputs": [
      {
        "components": [
          { "internalType": "bool", "name": "isX402", "type": "bool" },
          { "internalType": "bool", "name": "isBudgetReceived", "type": "bool" },
        ],
        "internalType": "struct ACPTypes.X402PaymentDetail",
        "name": "",
        "type": "tuple",
      },
    ],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "bytes32", "name": "role", "type": "bytes32" },
      { "internalType": "address", "name": "account", "type": "address" },
    ],
    "name": "grantRole",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "bytes32", "name": "role", "type": "bytes32" },
      { "internalType": "address", "name": "account", "type": "address" },
    ],
    "name": "hasRole",
    "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [{ "internalType": "uint256", "name": "jobId", "type": "uint256" }],
    "name": "incrementMemoCount",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "address", "name": "acpContract_", "type": "address" },
    ],
    "name": "initialize",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "jobCounter",
    "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }],
    "name": "jobs",
    "outputs": [
      { "internalType": "uint256", "name": "id", "type": "uint256" },
      { "internalType": "uint256", "name": "accountId", "type": "uint256" },
      { "internalType": "address", "name": "client", "type": "address" },
      { "internalType": "address", "name": "provider", "type": "address" },
      { "internalType": "address", "name": "evaluator", "type": "address" },
      { "internalType": "address", "name": "creator", "type": "address" },
      { "internalType": "uint256", "name": "budget", "type": "uint256" },
      {
        "internalType": "contract IERC20",
        "name": "jobPaymentToken",
        "type": "address",
      },
      { "internalType": "enum ACPTypes.JobPhase", "name": "phase", "type": "uint8" },
      { "internalType": "uint256", "name": "expiredAt", "type": "uint256" },
      { "internalType": "uint256", "name": "createdAt", "type": "uint256" },
      { "internalType": "uint256", "name": "memoCount", "type": "uint256" },
      { "internalType": "string", "name": "metadata", "type": "string" },
      { "internalType": "uint256", "name": "amountClaimed", "type": "uint256" },
    ],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "proxiableUUID",
    "outputs": [{ "internalType": "bytes32", "name": "", "type": "bytes32" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "bytes32", "name": "role", "type": "bytes32" },
      { "internalType": "address", "name": "callerConfirmation", "type": "address" },
    ],
    "name": "renounceRole",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "bytes32", "name": "role", "type": "bytes32" },
      { "internalType": "address", "name": "account", "type": "address" },
    ],
    "name": "revokeRole",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "uint256", "name": "jobId", "type": "uint256" },
      { "internalType": "uint256", "name": "budget", "type": "uint256" },
      {
        "internalType": "contract IERC20",
        "name": "paymentToken",
        "type": "address",
      },
    ],
    "name": "setJobBudget",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "x402PaymentTokenAddress",
        "type": "address",
      },
    ],
    "name": "setX402PaymentToken",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [{ "internalType": "bytes4", "name": "interfaceId", "type": "bytes4" }],
    "name": "supportsInterface",
    "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "address", "name": "acpContract_", "type": "address" },
    ],
    "name": "updateContracts",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "uint256", "name": "jobId", "type": "uint256" },
      {
        "internalType": "enum ACPTypes.JobPhase",
        "name": "newPhase",
        "type": "uint8",
      },
    ],
    "name": "updateJobPhase",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "address", "name": "newImplementation", "type": "address" },
      { "internalType": "bytes", "name": "data", "type": "bytes" },
    ],
    "name": "upgradeToAndCall",
    "outputs": [],
    "stateMutability": "payable",
    "type": "function",
  },
  {
    "inputs": [
      { "internalType": "address", "name": "", "type": "address" },
      { "internalType": "uint256", "name": "", "type": "uint256" },
    ],
    "name": "userJobs",
    "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [{ "internalType": "uint256", "name": "jobId", "type": "uint256" }],
    "name": "x402PaymentDetails",
    "outputs": [
      { "internalType": "bool", "name": "isX402", "type": "bool" },
      { "internalType": "bool", "name": "isBudgetReceived", "type": "bool" },
    ],
    "stateMutability": "view",
    "type": "function",
  },
  {
    "inputs": [],
    "name": "x402PaymentToken",
    "outputs": [{ "internalType": "contract IERC20", "name": "", "type": "address" }],
    "stateMutability": "view",
    "type": "function",
  },
];