/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import com.github.rjeschke.txtmark.Processor;
import java.util.Collections;
import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class MarkDownProcessor {
    private Dialect dialect;

    public MarkDownProcessor(Dialect dialect) {
        this.dialect = dialect;
    }

    public String process(String source2, String context) {
        if (source2 == null) {
            return null;
        }
        if ("".equals(source2)) {
            return "";
        }
        switch (this.dialect) {
            case DARING_FIREBALL: {
                return Processor.process((String)source2);
            }
            case COMMON_MARK: {
                return this.processCommonMark(source2);
            }
        }
        throw new Error("Unknown Markdown Dialect: " + this.dialect.toString() + " at " + context);
    }

    private String processCommonMark(String source2) {
        Set<Extension> extensions = Collections.singleton(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        Node document = parser.parse(source2);
        HtmlRenderer renderer = HtmlRenderer.builder().extensions(extensions).build();
        String html = renderer.render(document);
        html = html.replace("<table>", "<table class=\"grid\">");
        return html;
    }

    public static boolean isSimpleMarkdown(String description) {
        return !description.contains("\n");
    }

    public static enum Dialect {
        DARING_FIREBALL,
        COMMON_MARK;

    }
}

