/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ListMode;

public class ListModeEnumFactory
implements EnumFactory<ListMode> {
    @Override
    public ListMode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("working".equals(codeString)) {
            return ListMode.WORKING;
        }
        if ("snapshot".equals(codeString)) {
            return ListMode.SNAPSHOT;
        }
        if ("changes".equals(codeString)) {
            return ListMode.CHANGES;
        }
        throw new IllegalArgumentException("Unknown ListMode code '" + codeString + "'");
    }

    @Override
    public String toCode(ListMode code) {
        if (code == ListMode.WORKING) {
            return "working";
        }
        if (code == ListMode.SNAPSHOT) {
            return "snapshot";
        }
        if (code == ListMode.CHANGES) {
            return "changes";
        }
        return "?";
    }

    @Override
    public String toSystem(ListMode code) {
        return code.getSystem();
    }
}

