/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EffectEstimateType {
    RELATIVERR,
    RELATIVEOR,
    RELATIVEHR,
    ABSOLUTEARD,
    ABSOLUTEMEANDIFF,
    ABSOLUTESMD,
    ABSOLUTEMEDIANDIFF,
    NULL;


    public static EffectEstimateType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("relative-RR".equals(codeString)) {
            return RELATIVERR;
        }
        if ("relative-OR".equals(codeString)) {
            return RELATIVEOR;
        }
        if ("relative-HR".equals(codeString)) {
            return RELATIVEHR;
        }
        if ("absolute-ARD".equals(codeString)) {
            return ABSOLUTEARD;
        }
        if ("absolute-MeanDiff".equals(codeString)) {
            return ABSOLUTEMEANDIFF;
        }
        if ("absolute-SMD".equals(codeString)) {
            return ABSOLUTESMD;
        }
        if ("absolute-MedianDiff".equals(codeString)) {
            return ABSOLUTEMEDIANDIFF;
        }
        throw new FHIRException("Unknown EffectEstimateType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RELATIVERR: {
                return "relative-RR";
            }
            case RELATIVEOR: {
                return "relative-OR";
            }
            case RELATIVEHR: {
                return "relative-HR";
            }
            case ABSOLUTEARD: {
                return "absolute-ARD";
            }
            case ABSOLUTEMEANDIFF: {
                return "absolute-MeanDiff";
            }
            case ABSOLUTESMD: {
                return "absolute-SMD";
            }
            case ABSOLUTEMEDIANDIFF: {
                return "absolute-MedianDiff";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/effect-estimate-type";
    }

    public String getDefinition() {
        switch (this) {
            case RELATIVERR: {
                return "relative risk (a type of relative effect estimate).";
            }
            case RELATIVEOR: {
                return "odds ratio (a type of relative effect estimate).";
            }
            case RELATIVEHR: {
                return "hazard ratio (a type of relative effect estimate).";
            }
            case ABSOLUTEARD: {
                return "absolute risk difference (a type of absolute effect estimate).";
            }
            case ABSOLUTEMEANDIFF: {
                return "mean difference (a type of absolute effect estimate).";
            }
            case ABSOLUTESMD: {
                return "standardized mean difference (a type of absolute effect estimate).";
            }
            case ABSOLUTEMEDIANDIFF: {
                return "median difference (a type of absolute effect estimate).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RELATIVERR: {
                return "relative risk";
            }
            case RELATIVEOR: {
                return "odds ratio";
            }
            case RELATIVEHR: {
                return "hazard ratio";
            }
            case ABSOLUTEARD: {
                return "absolute risk difference";
            }
            case ABSOLUTEMEANDIFF: {
                return "mean difference";
            }
            case ABSOLUTESMD: {
                return "standardized mean difference";
            }
            case ABSOLUTEMEDIANDIFF: {
                return "median difference";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

