/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConsentScope {
    ADR,
    RESEARCH,
    PATIENTPRIVACY,
    TREATMENT,
    NULL;


    public static ConsentScope fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("adr".equals(codeString)) {
            return ADR;
        }
        if ("research".equals(codeString)) {
            return RESEARCH;
        }
        if ("patient-privacy".equals(codeString)) {
            return PATIENTPRIVACY;
        }
        if ("treatment".equals(codeString)) {
            return TREATMENT;
        }
        throw new FHIRException("Unknown ConsentScope code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ADR: {
                return "adr";
            }
            case RESEARCH: {
                return "research";
            }
            case PATIENTPRIVACY: {
                return "patient-privacy";
            }
            case TREATMENT: {
                return "treatment";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/consentscope";
    }

    public String getDefinition() {
        switch (this) {
            case ADR: {
                return "Actions to be taken if they are no longer able to make decisions for themselves";
            }
            case RESEARCH: {
                return "Consent to participate in research protocol and information sharing required";
            }
            case PATIENTPRIVACY: {
                return "Agreement to collect, access, use or disclose (share) information";
            }
            case TREATMENT: {
                return "Consent to undergo a specific treatment";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ADR: {
                return "Advanced Care Directive";
            }
            case RESEARCH: {
                return "Research";
            }
            case PATIENTPRIVACY: {
                return "Privacy Consent";
            }
            case TREATMENT: {
                return "Treatment";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

