/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CertaintySubcomponentRating {
    NOCHANGE,
    DOWNCODE1,
    DOWNCODE2,
    DOWNCODE3,
    UPCODE1,
    UPCODE2,
    NOCONCERN,
    SERIOUSCONCERN,
    CRITICALCONCERN,
    PRESENT,
    ABSENT,
    NULL;


    public static CertaintySubcomponentRating fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("no-change".equals(codeString)) {
            return NOCHANGE;
        }
        if ("downcode1".equals(codeString)) {
            return DOWNCODE1;
        }
        if ("downcode2".equals(codeString)) {
            return DOWNCODE2;
        }
        if ("downcode3".equals(codeString)) {
            return DOWNCODE3;
        }
        if ("upcode1".equals(codeString)) {
            return UPCODE1;
        }
        if ("upcode2".equals(codeString)) {
            return UPCODE2;
        }
        if ("no-concern".equals(codeString)) {
            return NOCONCERN;
        }
        if ("serious-concern".equals(codeString)) {
            return SERIOUSCONCERN;
        }
        if ("critical-concern".equals(codeString)) {
            return CRITICALCONCERN;
        }
        if ("present".equals(codeString)) {
            return PRESENT;
        }
        if ("absent".equals(codeString)) {
            return ABSENT;
        }
        throw new FHIRException("Unknown CertaintySubcomponentRating code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOCHANGE: {
                return "no-change";
            }
            case DOWNCODE1: {
                return "downcode1";
            }
            case DOWNCODE2: {
                return "downcode2";
            }
            case DOWNCODE3: {
                return "downcode3";
            }
            case UPCODE1: {
                return "upcode1";
            }
            case UPCODE2: {
                return "upcode2";
            }
            case NOCONCERN: {
                return "no-concern";
            }
            case SERIOUSCONCERN: {
                return "serious-concern";
            }
            case CRITICALCONCERN: {
                return "critical-concern";
            }
            case PRESENT: {
                return "present";
            }
            case ABSENT: {
                return "absent";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/certainty-subcomponent-rating";
    }

    public String getDefinition() {
        switch (this) {
            case NOCHANGE: {
                return "no change to quality rating.";
            }
            case DOWNCODE1: {
                return "reduce quality rating by 1.";
            }
            case DOWNCODE2: {
                return "reduce quality rating by 2.";
            }
            case DOWNCODE3: {
                return "reduce quality rating by 3.";
            }
            case UPCODE1: {
                return "increase quality rating by 1.";
            }
            case UPCODE2: {
                return "increase quality rating by 2.";
            }
            case NOCONCERN: {
                return "no serious concern.";
            }
            case SERIOUSCONCERN: {
                return "serious concern.";
            }
            case CRITICALCONCERN: {
                return "critical concern.";
            }
            case PRESENT: {
                return "possible reason for increasing quality rating was checked and found to bepresent.";
            }
            case ABSENT: {
                return "possible reason for increasing quality rating was checked and found to be absent.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOCHANGE: {
                return "no change to rating";
            }
            case DOWNCODE1: {
                return "reduce rating: -1";
            }
            case DOWNCODE2: {
                return "reduce rating: -2";
            }
            case DOWNCODE3: {
                return "reduce rating: -3";
            }
            case UPCODE1: {
                return "increase rating: +1";
            }
            case UPCODE2: {
                return "increase rating: +2";
            }
            case NOCONCERN: {
                return "no serious concern";
            }
            case SERIOUSCONCERN: {
                return "serious concern";
            }
            case CRITICALCONCERN: {
                return "critical concern";
            }
            case PRESENT: {
                return "present";
            }
            case ABSENT: {
                return "absent";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

