/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.text.DecimalFormat;

public class FileUtil {
    private static final String[] UNITS = new String[]{"Bytes", "kB", "MB", "GB", "TB"};

    public static String formatFileSize(long theBytes) {
        if (theBytes <= 0L) {
            return "0 " + UNITS[0];
        }
        int digitGroups = (int)(Math.log10(theBytes) / Math.log10(1024.0));
        digitGroups = Math.min(digitGroups, UNITS.length - 1);
        return new DecimalFormat("###0.#").format((double)theBytes / Math.pow(1024.0, digitGroups)) + " " + UNITS[digitGroups];
    }
}

