/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.i18n.Msg;
import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingAndLimitingInputStream
extends InputStream {
    private final int myMaxBytes;
    private final CountingInputStream myWrap;

    @Override
    public int read() throws IOException {
        int retVal = this.myWrap.read();
        this.validateCount();
        return retVal;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int retVal = this.myWrap.read(b, off, len);
        this.validateCount();
        return retVal;
    }

    @Override
    public int read(byte[] theRead) throws IOException {
        int retVal = this.myWrap.read(theRead);
        this.validateCount();
        return retVal;
    }

    private void validateCount() throws IOException {
        if (this.myWrap.getCount() > (long)this.myMaxBytes) {
            throw new IOException(Msg.code(1807) + "Stream exceeds maximum allowable size: " + this.myMaxBytes);
        }
    }

    public CountingAndLimitingInputStream(InputStream theWrap, int theMaxBytes) {
        this.myWrap = new CountingInputStream(theWrap);
        this.myMaxBytes = theMaxBytes;
    }
}

