/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative2;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.narrative.DefaultThymeleafNarrativeGenerator;
import ca.uhn.fhir.narrative2.INarrativeTemplate;
import ca.uhn.fhir.narrative2.INarrativeTemplateManifest;
import ca.uhn.fhir.narrative2.NarrativeTemplate;
import ca.uhn.fhir.narrative2.TemplateTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarrativeTemplateManifest
implements INarrativeTemplateManifest {
    private static final Logger ourLog = LoggerFactory.getLogger(NarrativeTemplateManifest.class);
    private final Map<String, List<NarrativeTemplate>> myResourceTypeToTemplate;
    private final Map<String, List<NarrativeTemplate>> myDatatypeToTemplate;
    private final Map<String, List<NarrativeTemplate>> myNameToTemplate;
    private final Map<String, List<NarrativeTemplate>> myClassToTemplate;
    private final int myTemplateCount;

    private NarrativeTemplateManifest(Collection<NarrativeTemplate> theTemplates) {
        HashMap<String, List> resourceTypeToTemplate = new HashMap<String, List>();
        HashMap<String, List> datatypeToTemplate = new HashMap<String, List>();
        HashMap<String, List> nameToTemplate = new HashMap<String, List>();
        HashMap<String, List> classToTemplate = new HashMap<String, List>();
        for (NarrativeTemplate nextTemplate : theTemplates) {
            nameToTemplate.computeIfAbsent(nextTemplate.getTemplateName(), t -> new ArrayList()).add(nextTemplate);
            for (String string : nextTemplate.getAppliesToResourceTypes()) {
                resourceTypeToTemplate.computeIfAbsent(string.toUpperCase(), t -> new ArrayList()).add(nextTemplate);
            }
            for (String string : nextTemplate.getAppliesToDataTypes()) {
                datatypeToTemplate.computeIfAbsent(string.toUpperCase(), t -> new ArrayList()).add(nextTemplate);
            }
            for (Class clazz : nextTemplate.getAppliesToClasses()) {
                classToTemplate.computeIfAbsent(clazz.getName(), t -> new ArrayList()).add(nextTemplate);
            }
        }
        this.myTemplateCount = theTemplates.size();
        this.myClassToTemplate = NarrativeTemplateManifest.makeImmutable(classToTemplate);
        this.myNameToTemplate = NarrativeTemplateManifest.makeImmutable(nameToTemplate);
        this.myResourceTypeToTemplate = NarrativeTemplateManifest.makeImmutable(resourceTypeToTemplate);
        this.myDatatypeToTemplate = NarrativeTemplateManifest.makeImmutable(datatypeToTemplate);
    }

    public int getNamedTemplateCount() {
        return this.myTemplateCount;
    }

    @Override
    public List<INarrativeTemplate> getTemplateByResourceName(FhirContext theFhirContext, EnumSet<TemplateTypeEnum> theStyles, String theResourceName) {
        return NarrativeTemplateManifest.getFromMap(theStyles, theResourceName.toUpperCase(), this.myResourceTypeToTemplate);
    }

    @Override
    public List<INarrativeTemplate> getTemplateByName(FhirContext theFhirContext, EnumSet<TemplateTypeEnum> theStyles, String theName) {
        return NarrativeTemplateManifest.getFromMap(theStyles, theName, this.myNameToTemplate);
    }

    @Override
    public List<INarrativeTemplate> getTemplateByElement(FhirContext theFhirContext, EnumSet<TemplateTypeEnum> theStyles, IBase theElement) {
        List<INarrativeTemplate> retVal = NarrativeTemplateManifest.getFromMap(theStyles, theElement.getClass().getName(), this.myClassToTemplate);
        if (retVal.isEmpty()) {
            if (theElement instanceof IBaseResource) {
                String resourceName = theFhirContext.getResourceDefinition((IBaseResource)theElement).getName();
                retVal = this.getTemplateByResourceName(theFhirContext, theStyles, resourceName);
            } else {
                String datatypeName = theFhirContext.getElementDefinition(theElement.getClass()).getName();
                retVal = NarrativeTemplateManifest.getFromMap(theStyles, datatypeName.toUpperCase(), this.myDatatypeToTemplate);
            }
        }
        return retVal;
    }

    public static NarrativeTemplateManifest forManifestFileLocation(String ... thePropertyFilePaths) throws IOException {
        return NarrativeTemplateManifest.forManifestFileLocation(Arrays.asList(thePropertyFilePaths));
    }

    public static NarrativeTemplateManifest forManifestFileLocation(Collection<String> thePropertyFilePaths) throws IOException {
        ourLog.debug("Loading narrative properties file(s): {}", thePropertyFilePaths);
        ArrayList<String> manifestFileContents = new ArrayList<String>(thePropertyFilePaths.size());
        for (String next : thePropertyFilePaths) {
            String resource = NarrativeTemplateManifest.loadResource(next);
            manifestFileContents.add(resource);
        }
        return NarrativeTemplateManifest.forManifestFileContents(manifestFileContents);
    }

    public static NarrativeTemplateManifest forManifestFileContents(String ... theResources) throws IOException {
        return NarrativeTemplateManifest.forManifestFileContents(Arrays.asList(theResources));
    }

    public static NarrativeTemplateManifest forManifestFileContents(Collection<String> theResources) throws IOException {
        ArrayList<NarrativeTemplate> templates = new ArrayList<NarrativeTemplate>();
        for (String next : theResources) {
            templates.addAll(NarrativeTemplateManifest.loadProperties(next));
        }
        return new NarrativeTemplateManifest(templates);
    }

    private static Collection<NarrativeTemplate> loadProperties(String theManifestText) throws IOException {
        HashMap<String, NarrativeTemplate> nameToTemplate = new HashMap<String, NarrativeTemplate>();
        Properties file = new Properties();
        file.load(new StringReader(theManifestText));
        for (Object nextKeyObj : file.keySet()) {
            String nextKey = (String)nextKeyObj;
            Validate.isTrue(StringUtils.countMatches((CharSequence)nextKey, ".") == 1, "Invalid narrative property file key: %s", nextKey);
            String name = nextKey.substring(0, nextKey.indexOf(46));
            Validate.notBlank(name, "Invalid narrative property file key: %s", nextKey);
            NarrativeTemplate nextTemplate = nameToTemplate.computeIfAbsent(name, t -> new NarrativeTemplate().setTemplateName(name));
            if (nextKey.endsWith(".class")) {
                String className = file.getProperty(nextKey);
                if (!StringUtils.isNotBlank(className)) continue;
                try {
                    nextTemplate.addAppliesToClass(Class.forName(className));
                    continue;
                }
                catch (ClassNotFoundException theE) {
                    throw new InternalErrorException(Msg.code(1867) + "Could not find class " + className + " declared in narative manifest");
                }
            }
            if (nextKey.endsWith(".profile")) {
                String profile = file.getProperty(nextKey);
                if (!StringUtils.isNotBlank(profile)) continue;
                nextTemplate.addAppliesToProfile(profile);
                continue;
            }
            if (nextKey.endsWith(".resourceType")) {
                String resourceType = file.getProperty(nextKey);
                Arrays.stream(resourceType.split(",")).map(t -> t.trim()).filter(t -> StringUtils.isNotBlank(t)).forEach(t -> nextTemplate.addAppliesToResourceType((String)t));
                continue;
            }
            if (nextKey.endsWith(".dataType")) {
                String dataType = file.getProperty(nextKey);
                Arrays.stream(dataType.split(",")).map(t -> t.trim()).filter(t -> StringUtils.isNotBlank(t)).forEach(t -> nextTemplate.addAppliesToDatatype((String)t));
                continue;
            }
            if (nextKey.endsWith(".style")) {
                String templateTypeName = file.getProperty(nextKey).toUpperCase();
                TemplateTypeEnum templateType = TemplateTypeEnum.valueOf(templateTypeName);
                nextTemplate.setTemplateType(templateType);
                continue;
            }
            if (nextKey.endsWith(".contextPath")) {
                String contextPath = file.getProperty(nextKey);
                nextTemplate.setContextPath(contextPath);
                continue;
            }
            if (nextKey.endsWith(".narrative")) {
                String narrativePropName = name + ".narrative";
                String narrativeName = file.getProperty(narrativePropName);
                if (!StringUtils.isNotBlank(narrativeName)) continue;
                nextTemplate.setTemplateFileName(narrativeName);
                continue;
            }
            if (nextKey.endsWith(".title")) {
                ourLog.debug("Ignoring title property as narrative generator no longer generates titles: {}", (Object)nextKey);
                continue;
            }
            throw new ConfigurationException(Msg.code(1868) + "Invalid property name: " + nextKey + " - the key must end in one of the expected extensions '.profile', '.resourceType', '.dataType', '.style', '.contextPath', '.narrative', '.title'");
        }
        return nameToTemplate.values();
    }

    static String loadResource(String name) throws IOException {
        if (name.startsWith("classpath:")) {
            String cpName = name.substring("classpath:".length());
            try (InputStream resource = DefaultThymeleafNarrativeGenerator.class.getResourceAsStream(cpName);){
                if (resource == null) {
                    try (InputStream resource2 = DefaultThymeleafNarrativeGenerator.class.getResourceAsStream("/" + cpName);){
                        if (resource2 == null) {
                            throw new IOException(Msg.code(1869) + "Can not find '" + cpName + "' on classpath");
                        }
                        String string = IOUtils.toString(resource2, Charsets.UTF_8);
                        return string;
                    }
                }
                String string = IOUtils.toString(resource, Charsets.UTF_8);
                return string;
            }
        }
        if (name.startsWith("file:")) {
            File file = new File(name.substring("file:".length()));
            if (!file.exists()) {
                throw new IOException(Msg.code(1870) + "File not found: " + file.getAbsolutePath());
            }
            try (FileInputStream inputStream2 = new FileInputStream(file);){
                String string = IOUtils.toString((InputStream)inputStream2, Charsets.UTF_8);
                return string;
            }
        }
        throw new IOException(Msg.code(1871) + "Invalid resource name: '" + name + "' (must start with classpath: or file: )");
    }

    private static <T> List<INarrativeTemplate> getFromMap(EnumSet<TemplateTypeEnum> theStyles, T theKey, Map<T, List<NarrativeTemplate>> theMap) {
        return theMap.getOrDefault(theKey, Collections.emptyList()).stream().filter(t -> theStyles.contains((Object)t.getTemplateType())).collect(Collectors.toList());
    }

    private static <T> Map<T, List<NarrativeTemplate>> makeImmutable(Map<T, List<NarrativeTemplate>> theStyleToResourceTypeToTemplate) {
        theStyleToResourceTypeToTemplate.replaceAll((key, value) -> Collections.unmodifiableList(value));
        return Collections.unmodifiableMap(theStyleToResourceTypeToTemplate);
    }
}

