/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import spire.math.Algebraic;
import spire.math.Complex;
import spire.math.Natural$;
import spire.math.NaturalAlgebra;
import spire.math.Number;
import spire.math.Number$;
import spire.math.NumberTag;
import spire.math.Quaternion;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.UInt;
import spire.math.UInt$;
import spire.math.ULong$;

@ScalaSignature(bytes="\u0006\u0001\u0011ef!B\u0001\u0003\u0003C9!a\u0002(biV\u0014\u0018\r\u001c\u0006\u0003\u0007\u0011\tA!\\1uQ*\tQ!A\u0003ta&\u0014Xm\u0001\u0001\u0014\t\u0001AqB\u0005\t\u0003\u00135i\u0011A\u0003\u0006\u0003\u0007-Q\u0011\u0001D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d)\u00111bU2bY\u0006tU/\u001c2feB\u0011\u0011\u0002E\u0005\u0003#)\u0011qcU2bY\u0006tU/\\3sS\u000e\u001cuN\u001c<feNLwN\\:\u0011\u0005M!R\"A\u0006\n\u0005UY!\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u0015a\u0002A\"\u0001\u001e\u0003\u0015!\u0017nZ5u+\u0005q\u0002C\u0001\u000e \u0013\t\u0001#A\u0001\u0003V\u0013:$\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u00044pY\u0012$\u0015nZ5ug2+g\r^\u000b\u0003I!\"\"!\n\u001e\u0015\u0005\u0019*\u0004CA\u0014)\u0019\u0001!\u0011\"K\u0011!\u0002\u0003\u0005)\u0019\u0001\u0016\u0003\u0003\u0005\u000b\"a\u000b\u0018\u0011\u0005Ma\u0013BA\u0017\f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aE\u0018\n\u0005AZ!aA!os\"\u0012\u0001F\r\t\u0003'MJ!\u0001N\u0006\u0003\u0017M\u0004XmY5bY&TX\r\u001a\u0005\u0006m\u0005\u0002\raN\u0001\u0002MB)1\u0003\u000f\u0014\u001fM%\u0011\u0011h\u0003\u0002\n\rVt7\r^5p]JBQaO\u0011A\u0002\u0019\n\u0011!\u0019\u0005\u0006{\u0001!\tAP\u0001\u0010M>dG\rR5hSR\u001c(+[4iiV\u0011qH\u0011\u000b\u0003\u0001\u001a#\"!\u0011#\u0011\u0005\u001d\u0012E!C\u0015=A\u0003\u0005\tQ1\u0001+Q\t\u0011%\u0007C\u00037y\u0001\u0007Q\tE\u0003\u0014q\u0005s\u0012\tC\u0003<y\u0001\u0007\u0011\tC\u0003I\u0001\u0011\u0005\u0011*\u0001\u0006hKRtU/\u001c\"jiN,\u0012A\u0013\t\u0003'-K!\u0001T\u0006\u0003\u0007%sG\u000fC\u0003O\u0001\u0011\u0005\u0011*\u0001\bhKR$\u0015nZ5u\u0019\u0016tw\r\u001e5\t\u000bA\u0003A\u0011A)\u0002\rQ|G*[:u+\u0005\u0011\u0006cA*\\=9\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0007\n\u0005i[\u0011a\u00029bG.\fw-Z\u0005\u00039v\u0013A\u0001T5ti*\u0011!l\u0003\u0005\u0006?\u0002!\t\u0001Y\u0001\bi>\f%O]1z+\u0005\t\u0007cA\nc\u0015&\u00111m\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006K\u0002!\tAZ\u0001\te\u00164XM]:fIV\t\u0011\u0004C\u0003i\u0001\u0011\u0005a-\u0001\u0003ue&l\u0007\"\u00026\u0001\t\u0003Y\u0017aB5t/\"|G.\u001a\u000b\u0002YB\u00111#\\\u0005\u0003].\u0011qAQ8pY\u0016\fg\u000eC\u0003q\u0001\u0011\u0005\u0011/\u0001\u0006v]\u0012,'\u000f\\=j]\u001e$\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\\1oO*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0019y%M[3di\")1\u0010\u0001C\u0001y\u0006A\u0011N\u001c;WC2,X\rF\u0001K\u0011\u0015q\b\u0001\"\u0001\u0000\u0003%awN\\4WC2,X\r\u0006\u0002\u0002\u0002A\u00191#a\u0001\n\u0007\u0005\u00151B\u0001\u0003M_:<\u0007bBA\u0005\u0001\u0011\u0005\u00111B\u0001\u000bM2|\u0017\r\u001e,bYV,GCAA\u0007!\r\u0019\u0012qB\u0005\u0004\u0003#Y!!\u0002$m_\u0006$\bbBA\u000b\u0001\u0011\u0005\u0011qC\u0001\fI>,(\r\\3WC2,X\r\u0006\u0002\u0002\u001aA\u00191#a\u0007\n\u0007\u0005u1B\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0003C\u0001A\u0011I%\u0002\u000bQ|\u0017J\u001c;\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(\u00051Ao\u001c'p]\u001e,\"!!\u0001\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005AAo\u001c\"jO&sG/\u0006\u0002\u00020A\u00191+!\r\n\u0007\u0005MRL\u0001\u0004CS\u001eLe\u000e\u001e\u0005\b\u0003o\u0001A\u0011IA\u001d\u0003!!xn\u0015;sS:<GCAA\u001e!\u0011\ti$!\u0012\u000f\t\u0005}\u0012\u0011\t\t\u0003+.I1!a\u0011\f\u0003\u0019\u0001&/\u001a3fM&!\u0011qIA%\u0005\u0019\u0019FO]5oO*\u0019\u00111I\u0006\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u00051Ao\u001c*faJ,\"!a\u000f\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u00051\u0011n\u001d.fe>,\u0012\u0001\u001c\u0005\b\u00033\u0002A\u0011AA+\u0003\u0015I7o\u00148f\u0011\u001d\ti\u0006\u0001C\u0001\u0003+\nQ![:PI\u0012Dq!!\u0019\u0001\t\u0003\t)&\u0001\u0004jg\u00163XM\u001c\u0005\u0007\u0003K\u0002A\u0011A%\u0002\u0015A|w/\u001a:PMR;x\u000eC\u0004\u0002j\u0001!\t!a\u001b\u0002\u000f\r|W\u000e]1sKR\u0019!*!\u001c\t\u000f\u0005=\u0014q\ra\u0001=\u0005\u0019!\u000f[:\t\u000f\u0005%\u0004\u0001\"\u0001\u0002tQ\u0019!*!\u001e\t\u000f\u0005=\u0014\u0011\u000fa\u00013!9\u0011\u0011\u0010\u0001\u0005F\u0005m\u0014AB3rk\u0006d7\u000fF\u0002m\u0003{Bq!a\u001c\u0002x\u0001\u0007a\u0006C\u0004\u0002\u0002\u0002!\t!a!\u0002\u0013\u0011*\u0017\u000fJ3rI\u0015\fHc\u00017\u0002\u0006\"9\u0011qNA@\u0001\u0004I\u0002bBAE\u0001\u0011\u0005\u00111R\u0001\fI\u0015\fHEY1oO\u0012*\u0017\u000fF\u0002m\u0003\u001bCq!a\u001c\u0002\b\u0002\u0007\u0011\u0004C\u0004\u0002\u0012\u0002!\t!a%\u0002\u000b\u0011bWm]:\u0015\u00071\f)\nC\u0004\u0002p\u0005=\u0005\u0019A\r\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\u0006AA\u0005\\3tg\u0012*\u0017\u000fF\u0002m\u0003;Cq!a\u001c\u0002\u0018\u0002\u0007\u0011\u0004C\u0004\u0002\"\u0002!\t!a)\u0002\u0011\u0011:'/Z1uKJ$2\u0001\\AS\u0011\u001d\ty'a(A\u0002eAq!!+\u0001\t\u0003\tY+A\u0006%OJ,\u0017\r^3sI\u0015\fHc\u00017\u0002.\"9\u0011qNAT\u0001\u0004I\u0002bBAI\u0001\u0011\u0005\u0011\u0011\u0017\u000b\u0004Y\u0006M\u0006bBA[\u0003_\u0003\rAH\u0001\u0002e\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005eFc\u00017\u0002<\"9\u0011QWA\\\u0001\u0004q\u0002bBAQ\u0001\u0011\u0005\u0011q\u0018\u000b\u0004Y\u0006\u0005\u0007bBA[\u0003{\u0003\rA\b\u0005\b\u0003S\u0003A\u0011AAc)\ra\u0017q\u0019\u0005\b\u0003k\u000b\u0019\r1\u0001\u001f\u0011\u001d\t\t\n\u0001C\u0001\u0003\u0017$2\u0001\\Ag\u0011!\t),!3A\u0002\u0005=\u0002bBAM\u0001\u0011\u0005\u0011\u0011\u001b\u000b\u0004Y\u0006M\u0007\u0002CA[\u0003\u001f\u0004\r!a\f\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002XR\u0019A.!7\t\u0011\u0005U\u0016Q\u001ba\u0001\u0003_Aq!!+\u0001\t\u0003\ti\u000eF\u0002m\u0003?D\u0001\"!.\u0002\\\u0002\u0007\u0011q\u0006\u0005\b\u0003G\u0004a\u0011AAs\u0003\u0015!\u0003\u000f\\;t)\rI\u0012q\u001d\u0005\b\u0003S\f\t\u000f1\u0001\u001f\u0003\t\u0011H\rC\u0004\u0002n\u00021\t!a<\u0002\r\u0011j\u0017N\\;t)\rI\u0012\u0011\u001f\u0005\b\u0003S\fY\u000f1\u0001\u001f\u0011\u001d\t)\u0010\u0001D\u0001\u0003o\fa\u0001\n;j[\u0016\u001cHcA\r\u0002z\"9\u0011\u0011^Az\u0001\u0004q\u0002bBA\u007f\u0001\u0011\u0005\u0011q`\u0001\u000bI\u0011Lg\u000f\n;jY\u0012,GcA\r\u0003\u0002!9\u0011\u0011^A~\u0001\u0004q\u0002b\u0002B\u0003\u0001\u0019\u0005!qA\u0001\u0005I\u0011Lg\u000fF\u0002\u001a\u0005\u0013Aq!!;\u0003\u0004\u0001\u0007a\u0004C\u0004\u0003\u000e\u00011\tAa\u0004\u0002\u0011\u0011\u0002XM]2f]R$2!\u0007B\t\u0011\u001d\tIOa\u0003A\u0002yAqA!\u0006\u0001\r\u0003\u00119\"\u0001\u0007%I&4H\u0005]3sG\u0016tG\u000f\u0006\u0003\u0003\u001a\t}\u0001#B\n\u0003\u001ceI\u0012b\u0001B\u000f\u0017\t1A+\u001e9mKJBq!!;\u0003\u0014\u0001\u0007a\u0004C\u0004\u0002d\u0002!\tAa\t\u0015\t\u0005=\"Q\u0005\u0005\t\u0003_\u0012\t\u00031\u0001\u00020!9\u0011Q\u001e\u0001\u0005\u0002\t%B\u0003BA\u0018\u0005WA\u0001\"a\u001c\u0003(\u0001\u0007\u0011q\u0006\u0005\b\u0003k\u0004A\u0011\u0001B\u0018)\u0011\tyC!\r\t\u0011\u0005=$Q\u0006a\u0001\u0003_Aq!!@\u0001\t\u0003\u0011)\u0004\u0006\u0003\u00020\t]\u0002\u0002CA8\u0005g\u0001\r!a\f\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003<Q!\u0011q\u0006B\u001f\u0011!\tyG!\u000fA\u0002\u0005=\u0002b\u0002B\u0007\u0001\u0011\u0005!\u0011\t\u000b\u0005\u0003_\u0011\u0019\u0005\u0003\u0005\u0002p\t}\u0002\u0019AA\u0018\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005\u000f\"BA!\u0013\u0003LA91Ca\u0007\u00020\u0005=\u0002\u0002CA8\u0005\u000b\u0002\r!a\f\t\u000f\u0005\r\b\u0001\"\u0001\u0003PQ\u0019\u0011D!\u0015\t\u000f\u0005=$Q\na\u00013!9\u0011Q\u001e\u0001\u0005\u0002\tUCcA\r\u0003X!9\u0011q\u000eB*\u0001\u0004I\u0002bBA{\u0001\u0011\u0005!1\f\u000b\u00043\tu\u0003bBA8\u00053\u0002\r!\u0007\u0005\b\u0005C\u0002A\u0011\u0001B2\u0003\r\u0001xn\u001e\u000b\u00043\t\u0015\u0004bBA8\u0005?\u0002\r!\u0007\u0005\b\u0005C\u0002A\u0011\u0001B5)\rI\"1\u000e\u0005\b\u0003_\u00129\u00071\u0001\u001f\u0011\u001d\ti\u0010\u0001C\u0001\u0005_\"2!\u0007B9\u0011\u001d\tyG!\u001cA\u0002eAqA!\u0002\u0001\t\u0003\u0011)\bF\u0002\u001a\u0005oBq!a\u001c\u0003t\u0001\u0007\u0011\u0004C\u0004\u0003\u000e\u0001!\tAa\u001f\u0015\u0007e\u0011i\bC\u0004\u0002p\te\u0004\u0019A\r\t\u000f\tU\u0001\u0001\"\u0001\u0003\u0002R!!\u0011\u0004BB\u0011\u001d\tyGa A\u0002eAqAa\"\u0001\t\u0013\u0011I)A\u0004m_:<G-\u001b<\u0015\r\te!1\u0012BH\u0011\u001d\u0011iI!\"A\u0002e\t1A\\;n\u0011\u001d\u0011\tJ!\"A\u0002e\tQ\u0001Z3o_6DqA!&\u0001\t\u0003\u00119*\u0001\u0006%Y\u0016\u001c8\u000f\n7fgN$2!\u0007BM\u0011\u001d\u0011YJa%A\u0002)\u000b\u0011A\u001c\u0005\b\u0005?\u0003A\u0011\u0001BQ\u0003\u0011\u0019\u0007n\u001c9\u0015\u0007e\u0011\u0019\u000bC\u0004\u0003\u001c\nu\u0005\u0019\u0001&\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003*\u0006\u0001Be\u001a:fCR,'\u000fJ4sK\u0006$XM\u001d\u000b\u00043\t-\u0006b\u0002BN\u0005K\u0003\rA\u0013\u0005\b\u0005_\u0003A\u0011\u0001BY\u0003\u0011!#-\u0019:\u0015\u0007e\u0011\u0019\fC\u0004\u0002p\t5\u0006\u0019A\r\t\u000f\t=\u0006\u0001\"\u0001\u00038R\u0019\u0011D!/\t\u000f\u0005=$Q\u0017a\u0001=!9!Q\u0018\u0001\u0005\u0002\t}\u0016\u0001\u0002\u0013b[B$2!\u0007Ba\u0011\u001d\tyGa/A\u0002eAqA!0\u0001\t\u0003\u0011)\rF\u0002\u001a\u0005\u000fDq!a\u001c\u0003D\u0002\u0007a\u0004C\u0004\u0003L\u0002!\tA!4\u0002\u0007\u0011*\b\u000fF\u0002\u001a\u0005\u001fDq!a\u001c\u0003J\u0002\u0007\u0011\u0004C\u0004\u0003L\u0002!\tAa5\u0015\u0007e\u0011)\u000eC\u0004\u0002p\tE\u0007\u0019\u0001\u0010*\u000b\u0001\u0011In!\"\u0007\u000f\tm'Q\u001c!\u0005N\t)A)[4ji\u001a1\u0011A\u0001E\u0001\u0005?\u001crA!8\u0003b\n\u001d(\u0003E\u0002\u0014\u0005GL1A!:\f\u0005\u0019\te.\u001f*fMB\u0019!D!;\n\u0007\t-(A\u0001\tOCR,(/\u00197J]N$\u0018M\\2fg\"9qC!8\u0005\u0002\t=HC\u0001By!\rQ\"Q\u001c\u0005\u000b\u0005#\u0013iN1A\u0005\u0006\ti\u0002\u0002\u0003B|\u0005;\u0004\u000bQ\u0002\u0010\u0002\r\u0011,gn\\7!\u0011!\u0011YP!8\u0005\u0004\tu\u0018a\u00048biV\u0014\u0018\r\u001c+p\u0005&<\u0017J\u001c;\u0015\t\u0005=\"q \u0005\b\u00057\u0013I\u00101\u0001\u001a\u0011!\u0019\u0019A!8\u0005\u0002\r\u0015\u0011!B1qa2LHcA\r\u0004\b!A1\u0011BB\u0001\u0001\u0004\u0019Y!\u0001\u0002vgB!1c!\u0004\u001f\u0013\r\u0019ya\u0003\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0002CB\u0002\u0005;$\taa\u0005\u0015\u0007e\u0019)\u0002\u0003\u0005\u0003\u001c\u000eE\u0001\u0019AA\u0001\u0011!\u0019\u0019A!8\u0005\u0002\reAcA\r\u0004\u001c!A!1TB\f\u0001\u0004\ty\u0003C\u0005\u0004 \tu'\u0019!C\u0005M\u0006)A/\u001a82q!A11\u0005BoA\u0003%\u0011$\u0001\u0004uK:\f\u0004\b\t\u0005\t\u0007\u0007\u0011i\u000e\"\u0001\u0004(Q\u0019\u0011d!\u000b\t\u0011\r-2Q\u0005a\u0001\u0003w\t\u0011a\u001d\u0005\n\u0007_\u0011iN1A\u0005\u0002\u0019\fAA_3s_\"A11\u0007BoA\u0003%\u0011$A\u0003{KJ|\u0007\u0005C\u0005\u00048\tu'\u0019!C\u0001M\u0006\u0019qN\\3\t\u0011\rm\"Q\u001cQ\u0001\ne\tAa\u001c8fA\u001dQ1q\bBo\u0003\u0003E\ta!\u0011\u0002\u000b\u0011Kw-\u001b;\u0011\t\r\r3QI\u0007\u0003\u0005;4!Ba7\u0003^\u0006\u0005\t\u0012AB$'\u0015\u0019)e!\u0013\u0013!!\u0019Ye!\u0015\u001f3\rUSBAB'\u0015\r\u0019yeC\u0001\beVtG/[7f\u0013\u0011\u0019\u0019f!\u0014\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0004D\te\u0007bB\f\u0004F\u0011\u00051\u0011\f\u000b\u0003\u0007\u0003B!\"a\u000e\u0004F\u0005\u0005IQIB/)\t\u0019y\u0006E\u0002t\u0007CJ1!a\u0012u\u0011)\u0019\u0019a!\u0012\u0002\u0002\u0013\u00055Q\r\u000b\u0007\u0007+\u001a9ga\u001b\t\u000f\r%41\ra\u0001=\u0005\tA\rC\u0004\u0004n\r\r\u0004\u0019A\r\u0002\u0005Qd\u0007BCB9\u0007\u000b\n\t\u0011\"!\u0004t\u00059QO\\1qa2LH\u0003BB;\u0007{\u0002RaEB<\u0007wJ1a!\u001f\f\u0005\u0019y\u0005\u000f^5p]B)1Ca\u0007\u001f3!Q1qPB8\u0003\u0003\u0005\ra!\u0016\u0002\u0007a$\u0003\u0007C\u0005\u0004\u0004\u000e\u0015\u0013\u0011!C\u0005c\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f\r\u001d\u00199I!8A\u0007\u0013\u00131!\u00128e'\u0019\u0019))\u0007\n\u0004\fB\u00191c!$\n\u0007\r=5BA\u0004Qe>$Wo\u0019;\t\u0015\r%4Q\u0011BK\u0002\u0013\u0005Q\u0004\u0003\u0006\u0004\u0016\u000e\u0015%\u0011#Q\u0001\ny\t!\u0001\u001a\u0011\t\u000f]\u0019)\t\"\u0001\u0004\u001aR!11TBO!\u0011\u0019\u0019e!\"\t\u000f\r%4q\u0013a\u0001=!1Ad!\"\u0005\u0002uA\u0001\"a9\u0004\u0006\u0012\u000511\u0015\u000b\u00043\r\u0015\u0006b\u0002BN\u0007C\u0003\rA\b\u0005\t\u0003[\u001c)\t\"\u0001\u0004*R\u0019\u0011da+\t\u000f\tm5q\u0015a\u0001=!A\u0011Q_BC\t\u0003\u0019y\u000bF\u0002\u001a\u0007cCqAa'\u0004.\u0002\u0007a\u0004\u0003\u0005\u0003\u0006\r\u0015E\u0011AB[)\rI2q\u0017\u0005\b\u00057\u001b\u0019\f1\u0001\u001f\u0011!\u0011ia!\"\u0005\u0002\rmFcA\r\u0004>\"9!1TB]\u0001\u0004q\u0002\u0002\u0003B\u000b\u0007\u000b#\ta!1\u0015\t\te11\u0019\u0005\b\u00057\u001by\f1\u0001\u001f\u0011)\u00199m!\"\u0002\u0002\u0013\u00051\u0011Z\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0004\u001c\u000e-\u0007\"CB5\u0007\u000b\u0004\n\u00111\u0001\u001f\u0011)\u0019ym!\"\u0012\u0002\u0013\u00051\u0011[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019\u0019NK\u0002\u001f\u0007+\\#aa6\u0011\t\re71]\u0007\u0003\u00077TAa!8\u0004`\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007C\\\u0011AC1o]>$\u0018\r^5p]&!1Q]Bn\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0007S\u001c))!A\u0005B\r-\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0004`!I1q^BC\u0003\u0003%\t!S\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0007g\u001c))!A\u0005\u0002\rU\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004]\r]\b\"CB}\u0007c\f\t\u00111\u0001K\u0003\rAH%\r\u0005\u000b\u0007{\u001c))!A\u0005B\r}\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0011\u0005\u0001#\u0002C\u0002\t\u0013qSB\u0001C\u0003\u0015\r!9aC\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002C\u0006\t\u000b\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\t\u001f\u0019))!A\u0005\u0002\u0011E\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\u00071$\u0019\u0002C\u0005\u0004z\u00125\u0011\u0011!a\u0001]!IAqCBC\u0003\u0003%\t\u0005`\u0001\tQ\u0006\u001c\bnQ8eK\"B1Q\u0011C\u000e\tC!\u0019\u0003E\u0002\u0014\t;I1\u0001b\b\f\u0005A\u0019VM]5bYZ+'o]5p]VKE)A\u0003wC2,XMH\u0001\u0001\u000f)!9C!8\u0002\u0002#\u0005A\u0011F\u0001\u0004\u000b:$\u0007\u0003BB\"\tW1!ba\"\u0003^\u0006\u0005\t\u0012\u0001C\u0017'\u0015!Y\u0003b\f\u0013!\u001d\u0019Y\u0005\"\r\u001f\u00077KA\u0001b\r\u0004N\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\t\u000f]!Y\u0003\"\u0001\u00058Q\u0011A\u0011\u0006\u0005\u000b\u0003o!Y#!A\u0005F\ru\u0003BCB\u0002\tW\t\t\u0011\"!\u0005>Q!11\u0014C \u0011\u001d\u0019I\u0007b\u000fA\u0002yA!b!\u001d\u0005,\u0005\u0005I\u0011\u0011C\")\u0011!)\u0005b\u0012\u0011\tM\u00199H\b\u0005\u000b\u0007\u007f\"\t%!AA\u0002\rm\u0005\"CBB\tW\t\t\u0011\"\u0003r\u0011%\u0019\u0019I!8\u0002\u0002\u0013%\u0011o\u0005\u0004\u0003Zf\u001121\u0012\u0005\u000b\u0007S\u0012IN!f\u0001\n\u0003i\u0002BCBK\u00053\u0014\t\u0012)A\u0005=!Q1Q\u000eBm\u0005+\u0007I\u0011\u00014\t\u0015\u0011]#\u0011\u001cB\tB\u0003%\u0011$A\u0002uY\u0002Bqa\u0006Bm\t\u0003!Y\u0006\u0006\u0004\u0004V\u0011uCq\f\u0005\b\u0007S\"I\u00061\u0001\u001f\u0011\u001d\u0019i\u0007\"\u0017A\u0002eAa\u0001\bBm\t\u0003i\u0002b\u0002C3\u00053$\tAZ\u0001\u0005i\u0006LG\u000e\u0003\u0005\u0002d\neG\u0011\u0001C5)\rIB1\u000e\u0005\b\u00057#9\u00071\u0001\u001f\u0011!\tiO!7\u0005\u0002\u0011=DcA\r\u0005r!9!1\u0014C7\u0001\u0004q\u0002\u0002CA{\u00053$\t\u0001\"\u001e\u0015\u0007e!9\bC\u0004\u0003\u001c\u0012M\u0004\u0019\u0001\u0010\t\u0011\t\u0015!\u0011\u001cC\u0001\tw\"2!\u0007C?\u0011\u001d\u0011Y\n\"\u001fA\u0002yA\u0001B!\u0004\u0003Z\u0012\u0005A\u0011\u0011\u000b\u00043\u0011\r\u0005b\u0002BN\t\u007f\u0002\rA\b\u0005\t\u0005+\u0011I\u000e\"\u0001\u0005\bR!!\u0011\u0004CE\u0011\u001d\u0011Y\n\"\"A\u0002yA!ba2\u0003Z\u0006\u0005I\u0011\u0001CG)\u0019\u0019)\u0006b$\u0005\u0012\"I1\u0011\u000eCF!\u0003\u0005\rA\b\u0005\n\u0007[\"Y\t%AA\u0002eA!ba4\u0003ZF\u0005I\u0011ABi\u0011)!9J!7\u0012\u0002\u0013\u0005A\u0011T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t!YJK\u0002\u001a\u0007+D!b!;\u0003Z\u0006\u0005I\u0011IBv\u0011%\u0019yO!7\u0002\u0002\u0013\u0005\u0011\n\u0003\u0006\u0004t\ne\u0017\u0011!C\u0001\tG#2A\fCS\u0011%\u0019I\u0010\")\u0002\u0002\u0003\u0007!\n\u0003\u0006\u0004~\ne\u0017\u0011!C!\u0007\u007fD!\u0002b\u0004\u0003Z\u0006\u0005I\u0011\u0001CV)\raGQ\u0016\u0005\n\u0007s$I+!AA\u00029B\u0011\u0002b\u0006\u0003Z\u0006\u0005I\u0011\t?)\u0011\teG1\u0004C\u0011\tGAs\u0001\u0001C\u000e\tC!\u0019cB\u0004\u00058\nA\tA!=\u0002\u000f9\u000bG/\u001e:bY\u0002")
public abstract class Natural
extends ScalaNumber
implements ScalaNumericConversions,
scala.Serializable {
    public static final long serialVersionUID = 0L;

    public static NumberTag.CustomTag<Natural> NaturalTag() {
        return Natural$.MODULE$.NaturalTag();
    }

    public static NaturalAlgebra NaturalAlgebra() {
        return Natural$.MODULE$.NaturalAlgebra();
    }

    public static Natural one() {
        return Natural$.MODULE$.one();
    }

    public static Natural zero() {
        return Natural$.MODULE$.zero();
    }

    public static Natural apply(String string) {
        return Natural$.MODULE$.apply(string);
    }

    public static Natural apply(BigInt bigInt) {
        return Natural$.MODULE$.apply(bigInt);
    }

    public static Natural apply(long l) {
        return Natural$.MODULE$.apply(l);
    }

    public static Natural apply(Seq<UInt> seq) {
        return Natural$.MODULE$.apply(seq);
    }

    public static BigInt naturalToBigInt(Natural natural) {
        return Natural$.MODULE$.naturalToBigInt(natural);
    }

    @Override
    public char toChar() {
        return ScalaNumericAnyConversions.toChar$(this);
    }

    @Override
    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public boolean isValidByte() {
        return ScalaNumericAnyConversions.isValidByte$(this);
    }

    @Override
    public boolean isValidShort() {
        return ScalaNumericAnyConversions.isValidShort$(this);
    }

    @Override
    public boolean isValidInt() {
        return ScalaNumericAnyConversions.isValidInt$(this);
    }

    @Override
    public boolean isValidChar() {
        return ScalaNumericAnyConversions.isValidChar$(this);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, x);
    }

    public abstract int digit();

    public <A> A foldDigitsLeft(A a, Function2<A, UInt, A> f) {
        return (A)this.recur$1(this, a, a, f);
    }

    public <A> A foldDigitsRight(A a, Function2<A, UInt, A> f) {
        return this.reversed().foldDigitsLeft(a, f);
    }

    public int getNumBits() {
        return this.recur$2(this, 0);
    }

    public int getDigitLength() {
        return this.recur$3(this, 0);
    }

    public List<UInt> toList() {
        return this.recur$4(this, Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public int[] toArray() {
        void var2_2;
        int n = this.getDigitLength();
        int[] arr = new int[n];
        this.recur$5(this, n - 1, arr);
        return var2_2;
    }

    public Natural reversed() {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            natural = this.recur$6(tail, new End(d));
        } else {
            natural = this;
        }
        return natural;
    }

    public Natural trim() {
        return this.recur$7(this.reversed()).reversed();
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public Object underlying() {
        return this;
    }

    @Override
    public int intValue() {
        return this.toInt();
    }

    @Override
    public long longValue() {
        return this.toLong();
    }

    @Override
    public float floatValue() {
        return this.toBigInt().toFloat();
    }

    @Override
    public double doubleValue() {
        return this.toBigInt().toDouble();
    }

    @Override
    public int toInt() {
        return UInt$.MODULE$.toInt$extension(this.digit()) & Integer.MAX_VALUE;
    }

    @Override
    public long toLong() {
        long l;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            l = UInt$.MODULE$.toLong$extension(d);
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            l = (tail.toLong() << (int)32L) + UInt$.MODULE$.toLong$extension(d);
        } else {
            throw new MatchError(natural);
        }
        return l;
    }

    public BigInt toBigInt() {
        BigInt bigInt;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            bigInt = package$.MODULE$.BigInt().apply(UInt$.MODULE$.toLong$extension(d));
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            bigInt = tail.toBigInt().$less$less(32).$plus(package$.MODULE$.BigInt().apply(UInt$.MODULE$.toLong$extension(d)));
        } else {
            throw new MatchError(natural);
        }
        return bigInt;
    }

    public String toString() {
        return this.recur$8(this, "");
    }

    public String toRepr() {
        return this.toList().mkString("Natural(", ", ", ")");
    }

    public boolean isZero() {
        return this.recur$9(this);
    }

    public boolean isOne() {
        boolean bl;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int n = end.d();
            bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1));
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int n = digit.d();
            Natural tail = digit.tl();
            bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) && tail.isZero();
        } else {
            throw new MatchError(natural);
        }
        return bl;
    }

    public boolean isOdd() {
        return UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(this.digit(), UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(1));
    }

    public boolean isEven() {
        return UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(this.digit(), UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(0));
    }

    public int powerOfTwo() {
        return this.recur$10(this, 0, -1);
    }

    public int compare(int rhs) {
        int n;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            n = UInt$.MODULE$.$less$extension(d, rhs) ? -1 : (UInt$.MODULE$.$greater$extension(d, rhs) ? 1 : 0);
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            n = tail.isZero() ? (UInt$.MODULE$.$greater$extension(d, rhs) ? 1 : (UInt$.MODULE$.$less$extension(d, rhs) ? -1 : 0)) : 1;
        } else {
            throw new MatchError(natural);
        }
        return n;
    }

    public int compare(Natural rhs) {
        return this.recur$11(this, rhs, 0);
    }

    public final boolean equals(Object rhs) {
        boolean bl;
        Object object = rhs;
        if (object instanceof Natural) {
            Natural natural = (Natural)object;
            bl = this.$eq$eq$eq(natural);
        } else if (object instanceof UInt) {
            int n = ((UInt)object).signed();
            bl = this.compare(n) == 0;
        } else if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            BigInt bigInt2 = this.toBigInt();
            BigInt bigInt3 = bigInt;
            bl = !(bigInt2 != null ? !((Object)bigInt2).equals(bigInt3) : bigInt3 != null);
        } else if (object instanceof SafeLong) {
            SafeLong safeLong = (SafeLong)object;
            bl = BoxesRunTime.equalsNumNum(SafeLong$.MODULE$.apply(this.toBigInt()), safeLong);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            bl = bigDecimal.isWhole() && BoxesRunTime.equalsNumNum(this.toBigInt(), bigDecimal);
        } else if (object instanceof Rational) {
            Rational rational = (Rational)object;
            bl = rational.isWhole() && BoxesRunTime.equalsNumNum(Rational$.MODULE$.apply(this.toBigInt()), rational);
        } else if (object instanceof Algebraic) {
            Algebraic algebraic = (Algebraic)object;
            bl = BoxesRunTime.equalsNumNum(algebraic, this);
        } else if (object instanceof Real) {
            Real real = (Real)object;
            bl = BoxesRunTime.equalsNumNum(this, real.toRational());
        } else if (object instanceof Number) {
            Number number = (Number)object;
            Number number2 = Number$.MODULE$.apply(this.toBigInt());
            Number number3 = number;
            bl = !(number2 != null ? !number2.equals(number3) : number3 != null);
        } else {
            Quaternion quaternion;
            Complex complex;
            bl = object instanceof Complex ? BoxesRunTime.equalsNumNum(complex = (Complex)object, this) : (object instanceof Quaternion ? BoxesRunTime.equalsNumNum(quaternion = (Quaternion)object, this) : this.unifiedPrimitiveEquals(object));
        }
        return bl;
    }

    public boolean $eq$eq$eq(Natural rhs) {
        return this.compare(rhs) == 0;
    }

    public boolean $eq$bang$eq(Natural rhs) {
        return !this.$eq$eq$eq(rhs);
    }

    public boolean $less(Natural rhs) {
        return this.compare(rhs) < 0;
    }

    public boolean $less$eq(Natural rhs) {
        return this.compare(rhs) <= 0;
    }

    public boolean $greater(Natural rhs) {
        return this.compare(rhs) > 0;
    }

    public boolean $greater$eq(Natural rhs) {
        return this.compare(rhs) >= 0;
    }

    public boolean $less(int r) {
        return this.compare(r) < 0;
    }

    public boolean $less$eq(int r) {
        return this.compare(r) <= 0;
    }

    public boolean $greater(int r) {
        return this.compare(r) > 0;
    }

    public boolean $greater$eq(int r) {
        return this.compare(r) >= 0;
    }

    public boolean $less(BigInt r) {
        return this.toBigInt().compare(r) < 0;
    }

    public boolean $less$eq(BigInt r) {
        return this.toBigInt().compare(r) <= 0;
    }

    public boolean $greater(BigInt r) {
        return this.toBigInt().compare(r) > 0;
    }

    public boolean $greater$eq(BigInt r) {
        return this.toBigInt().compare(r) >= 0;
    }

    public abstract Natural $plus(int var1);

    public abstract Natural $minus(int var1);

    public abstract Natural $times(int var1);

    public Natural $div$tilde(int rd) {
        return this.$div(rd);
    }

    public abstract Natural $div(int var1);

    public abstract Natural $percent(int var1);

    public abstract Tuple2<Natural, Natural> $div$percent(int var1);

    public BigInt $plus(BigInt rhs) {
        return this.toBigInt().$plus(rhs);
    }

    public BigInt $minus(BigInt rhs) {
        return this.toBigInt().$minus(rhs);
    }

    public BigInt $times(BigInt rhs) {
        return this.toBigInt().$times(rhs);
    }

    public BigInt $div$tilde(BigInt rhs) {
        return this.toBigInt().$div(rhs);
    }

    public BigInt $div(BigInt rhs) {
        return this.toBigInt().$div(rhs);
    }

    public BigInt $percent(BigInt rhs) {
        return this.toBigInt().$percent(rhs);
    }

    public Tuple2<BigInt, BigInt> $div$percent(BigInt rhs) {
        return this.toBigInt().$div$percent(rhs);
    }

    public Natural $plus(Natural rhs) {
        return Natural.recur$12(this, rhs, 0L);
    }

    public Natural $minus(Natural rhs) {
        if (this.$less(rhs)) {
            throw new ArithmeticException(new StringOps(Predef$.MODULE$.augmentString("negative subtraction: %s - %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this, rhs})));
        }
        return Natural.recur$13(this, rhs, 0L);
    }

    public Natural $times(Natural rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = rhs.$times(ld);
        } else if (natural2 instanceof Digit) {
            Natural natural3;
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end = (End)natural4;
                int rd = end.d();
                natural3 = this.$times(rd);
            } else if (natural4 instanceof Digit) {
                Digit digit2 = (Digit)natural4;
                int rd = digit2.d();
                Natural rtail = digit2.tl();
                natural3 = new Digit(UInt$.MODULE$.apply(0), new Digit(UInt$.MODULE$.apply(0), ltail.$times(rtail))).$plus(new Digit(UInt$.MODULE$.apply(0), ltail.$times(rd))).$plus(new Digit(UInt$.MODULE$.apply(0), rtail.$times(ld))).$plus(Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) * UInt$.MODULE$.toLong$extension(rd)));
            } else {
                throw new MatchError(natural4);
            }
            natural = natural3;
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    public Natural pow(Natural rhs) {
        return this._pow$1(Natural$.MODULE$.apply(1L), this, rhs);
    }

    public Natural pow(int rhs) {
        return this._pow$2(Natural$.MODULE$.apply(1L), this, rhs);
    }

    public Natural $div$tilde(Natural rhs) {
        return this.$div(rhs);
    }

    public Natural $div(Natural rhs) {
        Natural natural;
        Natural natural2 = rhs;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int rd = end.d();
            natural = this.$div(rd);
        } else if (natural2 instanceof Digit) {
            Natural natural3;
            Natural natural4 = this;
            if (natural4 instanceof End) {
                natural3 = new End(UInt$.MODULE$.apply(0));
            } else if (natural4 instanceof Digit) {
                Natural natural5;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        natural5 = this;
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            natural5 = this.$greater$greater(p);
                            break;
                        }
                        natural5 = this.longdiv(this, rhs)._1();
                        break;
                    }
                    default: {
                        throw new MatchError(BoxesRunTime.boxToInteger(n));
                    }
                }
                natural3 = natural5;
            } else {
                throw new MatchError(natural4);
            }
            natural = natural3;
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    public Natural $percent(Natural rhs) {
        Natural natural;
        Natural natural2 = rhs;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int rd = end.d();
            natural = this.$percent(rd);
        } else if (natural2 instanceof Digit) {
            End end;
            Natural natural3 = this;
            if (natural3 instanceof End) {
                End end2 = (End)natural3;
                int ld = end2.d();
                end = new End(ld);
            } else if (natural3 instanceof Digit) {
                Natural natural4;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        natural4 = new End(UInt$.MODULE$.apply(0));
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            natural4 = this.$amp(Natural$.MODULE$.apply(1L).$less$less(p).$minus(UInt$.MODULE$.apply(1)));
                            break;
                        }
                        natural4 = this.longdiv(this, rhs)._2();
                        break;
                    }
                    default: {
                        throw new MatchError(BoxesRunTime.boxToInteger(n));
                    }
                }
                end = natural4;
            } else {
                throw new MatchError(natural3);
            }
            natural = end;
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    public Tuple2<Natural, Natural> $div$percent(Natural rhs) {
        Tuple2<Natural, Natural> tuple2;
        Natural natural = rhs;
        if (natural instanceof End) {
            End end = (End)natural;
            int rd = end.d();
            tuple2 = new Tuple2<Natural, Natural>(this.$div(rd), this.$percent(rd));
        } else if (natural instanceof Digit) {
            Tuple2<Natural, Natural> tuple22;
            Natural natural2 = this;
            if (natural2 instanceof End) {
                tuple22 = new Tuple2<End, Natural>(new End(UInt$.MODULE$.apply(0)), this);
            } else if (natural2 instanceof Digit) {
                Tuple2<Natural, Natural> tuple23;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        tuple23 = new Tuple2<Natural, Natural>(this, Natural$.MODULE$.apply(0L));
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            Natural mask = Natural$.MODULE$.apply(1L).$less$less(p).$minus(UInt$.MODULE$.apply(1));
                            tuple23 = new Tuple2<Natural, Natural>(this.$greater$greater(p), this.$amp(mask));
                            break;
                        }
                        tuple23 = this.longdiv(this, rhs);
                        break;
                    }
                    default: {
                        throw new MatchError(BoxesRunTime.boxToInteger(n));
                    }
                }
                tuple22 = tuple23;
            } else {
                throw new MatchError(natural2);
            }
            tuple2 = tuple22;
        } else {
            throw new MatchError(natural);
        }
        return tuple2;
    }

    private Tuple2<Natural, Natural> longdiv(Natural num, Natural denom) {
        Natural rem = num;
        Natural quo = Natural$.MODULE$.apply(0L);
        int remBits = rem.getNumBits();
        int denomBits = denom.getNumBits();
        int shift = remBits - denomBits;
        while (shift >= 0) {
            Natural shifted = denom.$less$less(shift);
            if (shifted.$less$eq(rem)) {
                quo = quo.$plus(Natural$.MODULE$.apply(1L).$less$less(shift));
                rem = rem.$minus(shifted);
                remBits = rem.getNumBits();
                shift = remBits - denomBits;
                continue;
            }
            --shift;
        }
        return new Tuple2<Natural, Natural>(quo, rem);
    }

    public Natural $less$less(int n2) {
        int m = n2 & 0x1F;
        Natural num = Natural.recur$14(this, 0L, m);
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n2 / 32).foldLeft(num, (Function2<Natural, Object, Digit> & Serializable & scala.Serializable)(n, x$4) -> Natural.$anonfun$$less$less$1(n, BoxesRunTime.unboxToInt(x$4)));
    }

    public Natural chop(int n) {
        return this.recur$15(this, n);
    }

    public Natural $greater$greater(int n) {
        int m = n & 0x1F;
        return Natural.recur$16(this.chop(n / 32).reversed(), 0L, m).reversed();
    }

    public Natural $bar(Natural rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = new End(UInt$.MODULE$.$bar$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                natural3 = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), rtail);
            } else {
                throw new MatchError(natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = rhs;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                digit = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), ltail);
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                digit = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), ltail.$bar(rtail));
            } else {
                throw new MatchError(natural5);
            }
            natural = digit;
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    public Natural $bar(int rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = new End(UInt$.MODULE$.$bar$extension(ld, rhs));
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            natural = new Digit(UInt$.MODULE$.$bar$extension(ld, rhs), ltail);
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    public Natural $amp(Natural rhs) {
        return Natural.and$1(this, rhs).trim();
    }

    public Natural $amp(int rhs) {
        return new End(UInt$.MODULE$.$amp$extension(this.digit(), rhs));
    }

    public Natural $up(Natural rhs) {
        return Natural.xor$1(this, rhs).trim();
    }

    public Natural $up(int rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = new End(UInt$.MODULE$.$up$extension(ld, rhs));
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            natural = new Digit(UInt$.MODULE$.$up$extension(ld, rhs), ltail);
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    public boolean foldDigitsLeft$mZc$sp(boolean a, Function2<Object, UInt, Object> f) {
        return this.recur$18(this, a, a, f);
    }

    public byte foldDigitsLeft$mBc$sp(byte a, Function2<Object, UInt, Object> f) {
        return this.recur$19(this, a, a, f);
    }

    public char foldDigitsLeft$mCc$sp(char a, Function2<Object, UInt, Object> f) {
        return this.recur$20(this, a, a, f);
    }

    public double foldDigitsLeft$mDc$sp(double a, Function2<Object, UInt, Object> f) {
        return this.recur$21(this, a, a, f);
    }

    public float foldDigitsLeft$mFc$sp(float a, Function2<Object, UInt, Object> f) {
        return this.recur$22(this, a, a, f);
    }

    public int foldDigitsLeft$mIc$sp(int a, Function2<Object, UInt, Object> f) {
        return this.recur$23(this, a, a, f);
    }

    public long foldDigitsLeft$mJc$sp(long a, Function2<Object, UInt, Object> f) {
        return this.recur$24(this, a, a, f);
    }

    public short foldDigitsLeft$mSc$sp(short a, Function2<Object, UInt, Object> f) {
        return this.recur$25(this, a, a, f);
    }

    public void foldDigitsLeft$mVc$sp(BoxedUnit a, Function2<BoxedUnit, UInt, BoxedUnit> f) {
        this.recur$26(this, a, a, f);
    }

    public boolean foldDigitsRight$mZc$sp(boolean a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mZc$sp(a, f);
    }

    public byte foldDigitsRight$mBc$sp(byte a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mBc$sp(a, f);
    }

    public char foldDigitsRight$mCc$sp(char a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mCc$sp(a, f);
    }

    public double foldDigitsRight$mDc$sp(double a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mDc$sp(a, f);
    }

    public float foldDigitsRight$mFc$sp(float a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mFc$sp(a, f);
    }

    public int foldDigitsRight$mIc$sp(int a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mIc$sp(a, f);
    }

    public long foldDigitsRight$mJc$sp(long a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mJc$sp(a, f);
    }

    public short foldDigitsRight$mSc$sp(short a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mSc$sp(a, f);
    }

    public void foldDigitsRight$mVc$sp(BoxedUnit a, Function2<BoxedUnit, UInt, BoxedUnit> f) {
        this.reversed().foldDigitsLeft$mVc$sp(a, f);
    }

    private final Object recur$1(Natural next, Object sofar, Object a$1, Function2 f$1) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = f$1.apply(a$1, new UInt(d));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        Object r = f$1.apply(a$1, new UInt(d));
        return r;
    }

    private final int bit$1(int n, int b) {
        while (!UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
            ++b;
            n = UInt$.MODULE$.$greater$greater$greater$extension(n, 1);
        }
        return b;
    }

    private final int recur$2(Natural next, int b) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                Natural tail = digit.tl();
                b += 32;
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        int n = b + this.bit$1(d, 0);
        return n;
    }

    private final int recur$3(Natural next, int n) {
        block1: {
            Natural natural;
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                Natural tail = digit.tl();
                ++n;
                next = tail;
            }
            throw new MatchError(natural);
        }
        int n2 = n + 1;
        return n2;
    }

    private final List recur$4(Natural next, List sofar) {
        int d;
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d2 = digit.d();
                Natural tail = digit.tl();
                int n = d2;
                sofar = sofar.$colon$colon(new UInt(n));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int n = d = end.d();
        List<UInt> list = sofar.$colon$colon(new UInt(n));
        return list;
    }

    private final void recur$5(Natural next, int i, int[] arr$1) {
        int d;
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d2 = digit.d();
                Natural tail = digit.tl();
                arr$1[i] = d2;
                --i;
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        arr$1[i] = d = end.d();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final Natural recur$6(Natural next, Natural sofar) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = new Digit(d, sofar);
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        Digit digit = new Digit(d, sofar);
        return digit;
    }

    private final Natural recur$7(Natural next) {
        Natural natural;
        block4: {
            Natural natural2;
            while ((natural2 = next) instanceof Digit) {
                Digit digit = (Digit)natural2;
                int n = digit.d();
                Natural tail = digit.tl();
                if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                    next = tail;
                    continue;
                }
                natural = next;
                break block4;
            }
            if (natural2 instanceof End) {
                natural = next;
            } else {
                throw new MatchError(natural2);
            }
        }
        return natural;
    }

    private final String recur$8(Natural next, String s) {
        String string;
        block3: {
            Natural natural;
            block4: {
                Natural r;
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int d = end.d();
                        string = ((Object)BoxesRunTime.boxToLong(UInt$.MODULE$.toLong$extension(d))).toString() + s;
                        break block3;
                    }
                    if (!(natural instanceof Digit)) break block4;
                    Tuple2<Natural, Natural> tuple2 = next.$div$percent(Natural$.MODULE$.denom());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Natural q = tuple2._1();
                    Natural r2 = tuple2._2();
                    Tuple2<Natural, Natural> tuple22 = new Tuple2<Natural, Natural>(q, r2);
                    Tuple2<Natural, Natural> tuple23 = tuple22;
                    Natural q2 = tuple23._1();
                    r = tuple23._2();
                    if (q2.isZero()) break;
                    s = new StringOps(Predef$.MODULE$.augmentString("%09d%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(UInt$.MODULE$.toLong$extension(r.digit())), s}));
                    next = q2;
                }
                string = ((Object)BoxesRunTime.boxToLong(UInt$.MODULE$.toLong$extension(r.digit()))).toString() + s;
                break block3;
            }
            throw new MatchError(natural);
        }
        return string;
    }

    private final boolean recur$9(Natural next) {
        boolean bl;
        block2: {
            Natural natural;
            block3: {
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int n = end.d();
                        bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0));
                        break block2;
                    }
                    if (!(natural instanceof Digit)) break block3;
                    Digit digit = (Digit)natural;
                    int n = digit.d();
                    Natural tail = digit.tl();
                    if (!UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) break;
                    next = tail;
                }
                bl = false;
                break block2;
            }
            throw new MatchError(natural);
        }
        return bl;
    }

    private static final int test$1(int n) {
        int i;
        if ((n & -n) != n) {
            return -1;
        }
        for (i = 1; i < 32 && UInt$.MODULE$.$bang$eq$extension(UInt$.MODULE$.$greater$greater$greater$extension(n, i), UInt$.MODULE$.apply(0)); ++i) {
        }
        return i - 1;
    }

    private final int recur$10(Natural next, int shift, int bit) {
        int n;
        block3: {
            Natural natural;
            block4: {
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int n2 = end.d();
                        int t = Natural.test$1(n2);
                        n = t < 0 ? -1 : (bit < 0 ? shift + t : -1);
                        break block3;
                    }
                    if (!(natural instanceof Digit)) break block4;
                    Digit digit = (Digit)natural;
                    int n3 = digit.d();
                    Natural tail = digit.tl();
                    int t = Natural.test$1(n3);
                    if (t < 0) {
                        shift += 32;
                        next = tail;
                        continue;
                    }
                    if (bit >= 0) break;
                    bit = shift + t;
                    shift += 32;
                    next = tail;
                }
                n = -1;
                break block3;
            }
            throw new MatchError(natural);
        }
        return n;
    }

    private static final int cmp$1(int a, int b, int c) {
        return UInt$.MODULE$.$less$extension(a, b) ? -1 : (UInt$.MODULE$.$greater$extension(a, b) ? 1 : c);
    }

    private final int recur$11(Natural lhs, Natural rhs, int d) {
        int n;
        block6: {
            Natural natural;
            block7: {
                Natural natural2;
                block8: {
                    while (true) {
                        if ((natural = lhs) instanceof End) {
                            int n2;
                            End end = (End)natural;
                            int ld = end.d();
                            Natural natural3 = rhs;
                            if (natural3 instanceof End) {
                                End end2 = (End)natural3;
                                int rd = end2.d();
                                n2 = Natural.cmp$1(ld, rd, d);
                            } else if (natural3 instanceof Digit) {
                                n2 = -rhs.compare(ld);
                            } else {
                                throw new MatchError(natural3);
                            }
                            n = n2;
                            break block6;
                        }
                        if (!(natural instanceof Digit)) break block7;
                        Digit digit = (Digit)natural;
                        int ld = digit.d();
                        Natural ltail = digit.tl();
                        natural2 = rhs;
                        if (natural2 instanceof End) break block8;
                        if (!(natural2 instanceof Digit)) break;
                        Digit digit2 = (Digit)natural2;
                        int rd = digit2.d();
                        Natural rtail = digit2.tl();
                        d = Natural.cmp$1(ld, rd, d);
                        rhs = rtail;
                        lhs = ltail;
                    }
                    throw new MatchError(natural2);
                }
                End end = (End)natural2;
                int rd = end.d();
                int n3 = lhs.compare(rd);
                n = n3;
                break block6;
            }
            throw new MatchError(natural);
        }
        return n;
    }

    private static final Natural recur$12(Natural left, Natural right, long carry) {
        Natural natural;
        Natural natural2 = left;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = right;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry);
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                natural3 = new Digit(UInt$.MODULE$.apply(t), rtail.$plus(UInt$.MODULE$.apply(t >> 32)));
            } else {
                throw new MatchError(natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = right;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                digit = new Digit(UInt$.MODULE$.apply(t), ltail.$plus(UInt$.MODULE$.apply(t >> 32)));
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                digit = new Digit(UInt$.MODULE$.apply(t), Natural.recur$12(ltail, rtail, t >> 32));
            } else {
                throw new MatchError(natural5);
            }
            natural = digit;
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    private static final Natural recur$13(Natural left, Natural right, long carry) {
        Natural natural;
        Natural natural2 = left;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = right;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry);
            } else if (natural4 instanceof Digit) {
                long t;
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                Natural tl = rtail.$minus(UInt$.MODULE$.apply(-((t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry) >> 32)));
                natural3 = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else {
                throw new MatchError(natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = right;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                long t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry;
                Natural tl = ltail.$minus(UInt$.MODULE$.apply(-(t >> 32)));
                digit = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else if (natural5 instanceof Digit) {
                long t;
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                Natural tl = Natural.recur$13(ltail, rtail, -((t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry) >> 32));
                digit = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else {
                throw new MatchError(natural5);
            }
            natural = digit;
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    private final Natural _pow$1(Natural t, Natural b, Natural e) {
        while (!e.isZero()) {
            if (e.isOdd()) {
                Natural natural = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = natural;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private final Natural _pow$2(Natural t, Natural b, int e) {
        while (!UInt$.MODULE$.$eq$eq$extension(e, UInt$.MODULE$.apply(0))) {
            if (UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(e, UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(1))) {
                Natural natural = t.$times(b);
                e = UInt$.MODULE$.$greater$greater$extension(e, 1);
                b = b.$times(b);
                t = natural;
                continue;
            }
            e = UInt$.MODULE$.$greater$greater$extension(e, 1);
            b = b.$times(b);
        }
        return t;
    }

    private static final Natural recur$14(Natural next, long carry, int m$1) {
        Natural natural;
        Natural natural2 = next;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int d = end.d();
            natural = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(d) << m$1 | carry);
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            long t = UInt$.MODULE$.toLong$extension(d) << m$1 | carry;
            natural = new Digit(UInt$.MODULE$.apply(t), Natural.recur$14(tail, t >> 32, m$1));
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    public static final /* synthetic */ Digit $anonfun$$less$less$1(Natural n, int x$4) {
        return new Digit(UInt$.MODULE$.apply(0), n);
    }

    private final Natural recur$15(Natural next, int n) {
        Natural natural;
        block2: {
            block3: {
                Natural natural2;
                while (true) {
                    if (n <= 0) {
                        natural = next;
                        break block2;
                    }
                    natural2 = next;
                    if (natural2 instanceof End) break block3;
                    if (!(natural2 instanceof Digit)) break;
                    Digit digit = (Digit)natural2;
                    Natural tail = digit.tl();
                    --n;
                    next = tail;
                }
                throw new MatchError(natural2);
            }
            End end = new End(UInt$.MODULE$.apply(0));
            natural = end;
        }
        return natural;
    }

    private static final Natural recur$16(Natural next, long carry, int m$2) {
        Natural natural;
        Natural natural2 = next;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int d = end.d();
            natural = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(d) >> m$2 | carry);
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            long t = (UInt$.MODULE$.toLong$extension(d) | carry) << 32 - m$2;
            natural = new Digit(UInt$.MODULE$.apply(t >> 32), Natural.recur$16(tail, t & 0xFFFFFFFFL, m$2));
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    private static final Natural and$1(Natural lhs, Natural rhs) {
        End end;
        Natural natural = lhs;
        if (natural instanceof End) {
            End end2;
            End end3 = (End)natural;
            int ld = end3.d();
            Natural natural2 = rhs;
            if (natural2 instanceof End) {
                End end4 = (End)natural2;
                int rd = end4.d();
                end2 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else if (natural2 instanceof Digit) {
                Digit digit = (Digit)natural2;
                int rd = digit.d();
                end2 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else {
                throw new MatchError(natural2);
            }
            end = end2;
        } else if (natural instanceof Digit) {
            Natural natural3;
            Digit digit = (Digit)natural;
            int ld = digit.d();
            Natural ltail = digit.tl();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end5 = (End)natural4;
                int rd = end5.d();
                natural3 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit2 = (Digit)natural4;
                int rd = digit2.d();
                Natural rtail = digit2.tl();
                natural3 = new Digit(UInt$.MODULE$.$amp$extension(ld, rd), Natural.and$1(ltail, rtail));
            } else {
                throw new MatchError(natural4);
            }
            end = natural3;
        } else {
            throw new MatchError(natural);
        }
        return end;
    }

    private static final Natural xor$1(Natural lhs, Natural rhs) {
        Natural natural;
        Natural natural2 = lhs;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = new End(UInt$.MODULE$.$up$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                natural3 = new Digit(UInt$.MODULE$.$up$extension(ld, rd), rtail);
            } else {
                throw new MatchError(natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = rhs;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                digit = new Digit(UInt$.MODULE$.$up$extension(ld, rd), ltail);
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                digit = new Digit(UInt$.MODULE$.$up$extension(ld, rd), ltail.$up(rtail));
            } else {
                throw new MatchError(natural5);
            }
            natural = digit;
        } else {
            throw new MatchError(natural2);
        }
        return natural;
    }

    private final boolean recur$18(Natural next, boolean sofar, boolean a$2, Function2 f$2) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToBoolean(f$2.apply(BoxesRunTime.boxToBoolean(a$2), new UInt(d)));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        boolean bl = BoxesRunTime.unboxToBoolean(f$2.apply(BoxesRunTime.boxToBoolean(a$2), new UInt(d)));
        return bl;
    }

    private final byte recur$19(Natural next, byte sofar, byte a$3, Function2 f$3) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToByte(f$3.apply(BoxesRunTime.boxToByte(a$3), new UInt(d)));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        byte by = BoxesRunTime.unboxToByte(f$3.apply(BoxesRunTime.boxToByte(a$3), new UInt(d)));
        return by;
    }

    private final char recur$20(Natural next, char sofar, char a$4, Function2 f$4) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToChar(f$4.apply(BoxesRunTime.boxToCharacter(a$4), new UInt(d)));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        char c = BoxesRunTime.unboxToChar(f$4.apply(BoxesRunTime.boxToCharacter(a$4), new UInt(d)));
        return c;
    }

    private final double recur$21(Natural next, double sofar, double a$5, Function2 f$5) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToDouble(f$5.apply(BoxesRunTime.boxToDouble(a$5), new UInt(d)));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        double d2 = BoxesRunTime.unboxToDouble(f$5.apply(BoxesRunTime.boxToDouble(a$5), new UInt(d)));
        return d2;
    }

    private final float recur$22(Natural next, float sofar, float a$6, Function2 f$6) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToFloat(f$6.apply(BoxesRunTime.boxToFloat(a$6), new UInt(d)));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        float f = BoxesRunTime.unboxToFloat(f$6.apply(BoxesRunTime.boxToFloat(a$6), new UInt(d)));
        return f;
    }

    private final int recur$23(Natural next, int sofar, int a$7, Function2 f$7) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToInt(f$7.apply(BoxesRunTime.boxToInteger(a$7), new UInt(d)));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        int n = BoxesRunTime.unboxToInt(f$7.apply(BoxesRunTime.boxToInteger(a$7), new UInt(d)));
        return n;
    }

    private final long recur$24(Natural next, long sofar, long a$8, Function2 f$8) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToLong(f$8.apply(BoxesRunTime.boxToLong(a$8), new UInt(d)));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        long l = BoxesRunTime.unboxToLong(f$8.apply(BoxesRunTime.boxToLong(a$8), new UInt(d)));
        return l;
    }

    private final short recur$25(Natural next, short sofar, short a$9, Function2 f$9) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToShort(f$9.apply(BoxesRunTime.boxToShort(a$9), new UInt(d)));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        short s = BoxesRunTime.unboxToShort(f$9.apply(BoxesRunTime.boxToShort(a$9), new UInt(d)));
        return s;
    }

    private final void recur$26(Natural next, BoxedUnit sofar, BoxedUnit a$10, Function2 f$10) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = (BoxedUnit)f$10.apply(a$10, new UInt(d));
                next = tail;
            }
            throw new MatchError(natural);
        }
        End end = (End)natural;
        int d = end.d();
        BoxedUnit boxedUnit = (BoxedUnit)f$10.apply(a$10, new UInt(d));
    }

    public Natural() {
        ScalaNumericAnyConversions.$init$(this);
    }

    public static class Digit
    extends Natural
    implements Product {
        public static final long serialVersionUID = 0L;
        private final int d;
        private final Natural tl;

        public int d() {
            return this.d;
        }

        public Natural tl() {
            return this.tl;
        }

        @Override
        public int digit() {
            return this.d();
        }

        public Natural tail() {
            return this.tl();
        }

        @Override
        public Natural $plus(int n) {
            Digit digit;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                digit = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) + UInt$.MODULE$.toLong$extension(n);
                digit = new Digit(UInt$.MODULE$.apply(t), this.tail().$plus(UInt$.MODULE$.apply(t >> 32)));
            }
            return digit;
        }

        @Override
        public Natural $minus(int n) {
            Digit digit;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                digit = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) - UInt$.MODULE$.toLong$extension(n);
                digit = new Digit(UInt$.MODULE$.apply(t), this.tail().$minus(UInt$.MODULE$.apply(-(t >> 32))));
            }
            return digit;
        }

        @Override
        public Natural $times(int n) {
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? new End(n) : (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) ? this : Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(this.d()) * UInt$.MODULE$.toLong$extension(n)).$plus(new Digit(UInt$.MODULE$.apply(0), this.tl().$times(n))));
        }

        @Override
        public Natural $div(int n) {
            return this.$div$percent(n)._1();
        }

        @Override
        public Natural $percent(int n) {
            return this.$div$percent(n)._2();
        }

        @Override
        public Tuple2<Natural, Natural> $div$percent(int n) {
            Tuple2 tuple2;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1))) {
                tuple2 = new Tuple2(this, Natural$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new UInt[]{new UInt(UInt$.MODULE$.apply(0))})));
            } else {
                Natural natural = this.reversed();
                if (!(natural instanceof Digit)) {
                    throw new IllegalArgumentException("bug in reversed");
                }
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                int q = UInt$.MODULE$.$div$extension(d, n);
                int r = UInt$.MODULE$.$percent$extension(d, n);
                Tuple2 tuple22 = this.recur$17(tail, r, new End(q), n);
                tuple2 = tuple22;
            }
            return tuple2;
        }

        public Digit copy(int d, Natural tl) {
            return new Digit(d, tl);
        }

        public int copy$default$1() {
            return this.d();
        }

        public Natural copy$default$2() {
            return this.tl();
        }

        @Override
        public String productPrefix() {
            return "Digit";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new UInt(this.d());
                    break;
                }
                case 1: {
                    object = this.tl();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
            return object;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Digit;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        private final Tuple2 recur$17(Natural next, int rem, Natural sofar, int n$1) {
            long r;
            long q;
            block1: {
                Natural natural;
                while (true) {
                    long t = ULong$.MODULE$.$plus$extension(ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(rem) << 32), ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(next.digit())));
                    q = ULong$.MODULE$.toLong$extension(ULong$.MODULE$.$div$extension(t, ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(n$1))));
                    r = ULong$.MODULE$.toLong$extension(ULong$.MODULE$.$percent$extension(t, ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(n$1))));
                    natural = next;
                    if (natural instanceof End) break block1;
                    if (!(natural instanceof Digit)) break;
                    Digit digit = (Digit)natural;
                    Natural tail = digit.tl();
                    sofar = new Digit(UInt$.MODULE$.apply(q), sofar);
                    rem = UInt$.MODULE$.apply(r);
                    next = tail;
                }
                throw new MatchError(natural);
            }
            Tuple2<Digit, End> tuple2 = new Tuple2<Digit, End>(new Digit(UInt$.MODULE$.apply(q), sofar), new End(UInt$.MODULE$.apply(r)));
            return tuple2;
        }

        public Digit(int d, Natural tl) {
            this.d = d;
            this.tl = tl;
            Product.$init$(this);
        }
    }

    public static class End
    extends Natural
    implements Product {
        public static final long serialVersionUID = 0L;
        private final int d;

        public int d() {
            return this.d;
        }

        @Override
        public int digit() {
            return this.d();
        }

        @Override
        public Natural $plus(int n) {
            long t;
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? this : ((t = UInt$.MODULE$.toLong$extension(this.d()) + UInt$.MODULE$.toLong$extension(n)) <= 0xFFFFFFFFL ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), new End(UInt$.MODULE$.apply(1))));
        }

        @Override
        public Natural $minus(int n) {
            End end;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                end = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) - UInt$.MODULE$.toLong$extension(n);
                if (t >= 0L) {
                    end = new End(UInt$.MODULE$.apply((int)t));
                } else {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("illegal subtraction: %s %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this, new UInt(n)})));
                }
            }
            return end;
        }

        @Override
        public Natural $times(int n) {
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? new End(n) : (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) ? this : Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(this.d()) * UInt$.MODULE$.toLong$extension(n)));
        }

        @Override
        public Natural $div(int n) {
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            return new End(UInt$.MODULE$.$div$extension(this.d(), n));
        }

        @Override
        public Natural $percent(int n) {
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            return new End(UInt$.MODULE$.$percent$extension(this.d(), n));
        }

        @Override
        public Tuple2<Natural, Natural> $div$percent(int n) {
            return new Tuple2<Natural, Natural>(this.$div(n), this.$percent(n));
        }

        public End copy(int d) {
            return new End(d);
        }

        public int copy$default$1() {
            return this.d();
        }

        @Override
        public String productPrefix() {
            return "End";
        }

        @Override
        public int productArity() {
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return new UInt(this.d());
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof End;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public End(int d) {
            this.d = d;
            Product.$init$(this);
        }
    }
}

