/*
 * Decompiled with CFR 0.152.
 */
package scorex.util.encode;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$Ensuring$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.encode.BytesEncoder;

public final class Base58$
implements BytesEncoder {
    public static Base58$ MODULE$;
    private final String Alphabet;
    private final int[] DecodeTable;
    private final BigInt Base;

    static {
        new Base58$();
    }

    @Override
    public String Alphabet() {
        return this.Alphabet;
    }

    private int[] DecodeTable() {
        return this.DecodeTable;
    }

    private BigInt Base() {
        return this.Base;
    }

    @Override
    public String encode(byte[] input) {
        Serializable serializable;
        BigInt bi = package$.MODULE$.BigInt().apply(1, input);
        StringBuilder s = new StringBuilder();
        if (bi.$greater(BigInt$.MODULE$.int2bigInt(0))) {
            while (bi.$greater$eq(this.Base())) {
                Tuple2<BigInt, BigInt> tuple2 = bi.$div$percent(this.Base());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                BigInt newBi = tuple2._1();
                BigInt mod = tuple2._2();
                Tuple2<BigInt, BigInt> tuple22 = new Tuple2<BigInt, BigInt>(newBi, mod);
                Tuple2<BigInt, BigInt> tuple23 = tuple22;
                BigInt newBi2 = tuple23._1();
                BigInt mod2 = tuple23._2();
                s.insert(0, this.Alphabet().charAt(mod2.intValue()));
                bi = newBi2;
            }
            serializable = s.insert(0, this.Alphabet().charAt(bi.intValue()));
        } else {
            serializable = BoxedUnit.UNIT;
        }
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(input)).takeWhile((Function1<Object, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Base58$.$anonfun$encode$1(BoxesRunTime.unboxToByte(x$2)))))).foldLeft(s, (Function2<StringBuilder, Object, StringBuilder> & Serializable & scala.Serializable)(x0$1, x1$1) -> Base58$.$anonfun$encode$2(x0$1, BoxesRunTime.unboxToByte(x1$1))).toString();
    }

    @Override
    public Try<byte[]> decode(String input) {
        return Try$.MODULE$.apply((Function0<byte[]> & Serializable & scala.Serializable)() -> {
            BigInt decoded;
            BigInt bigInt = decoded = MODULE$.decodeToBigInteger(input);
            BigInt bigInt2 = package$.MODULE$.BigInt().apply(0);
            byte[] bytes = !(bigInt != null ? !((Object)bigInt).equals(bigInt2) : bigInt2 != null) ? Array$.MODULE$.emptyByteArray() : decoded.toByteArray();
            boolean stripSignByte = bytes.length > 1 && BoxesRunTime.unboxToByte(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head()) == 0 && bytes[1] < 0;
            int stripSignBytePos = stripSignByte ? 1 : 0;
            int leadingZeros = ((String)new StringOps(Predef$.MODULE$.augmentString(input)).takeWhile((Function1<Object, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(Base58$.$anonfun$decode$2(BoxesRunTime.unboxToChar(x$3))))).length();
            byte[] tmp = new byte[bytes.length - stripSignBytePos + leadingZeros];
            System.arraycopy(bytes, stripSignBytePos, tmp, leadingZeros, tmp.length - leadingZeros);
            return tmp;
        });
    }

    private BigInt decodeToBigInteger(String input) {
        return new StringOps(Predef$.MODULE$.augmentString(input)).foldRight(new Tuple2<BigInt, BigInt>(package$.MODULE$.BigInt().apply(0), package$.MODULE$.BigInt().apply(1)), (Function2<Object, Tuple2, Tuple2> & Serializable & scala.Serializable)(x0$1, x1$1) -> Base58$.$anonfun$decodeToBigInteger$1(BoxesRunTime.unboxToChar(x0$1), x1$1))._1();
    }

    private int toBase58(char c) {
        char x = c;
        return x < '1' ? -1 : (x <= 'z' ? this.DecodeTable()[x - 49] : -1);
    }

    public static final /* synthetic */ boolean $anonfun$encode$1(byte x$2) {
        return x$2 == 0;
    }

    public static final /* synthetic */ StringBuilder $anonfun$encode$2(StringBuilder x0$1, byte x1$1) {
        Tuple2<StringBuilder, Byte> tuple2 = new Tuple2<StringBuilder, Byte>(x0$1, BoxesRunTime.boxToByte(x1$1));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StringBuilder ss = tuple2._1();
        StringBuilder stringBuilder = ss.insert(0, MODULE$.Alphabet().charAt(0));
        return stringBuilder;
    }

    public static final /* synthetic */ boolean $anonfun$decode$2(char x$3) {
        return x$3 == MODULE$.Alphabet().charAt(0);
    }

    public static final /* synthetic */ Tuple2 $anonfun$decodeToBigInteger$1(char x0$1, Tuple2 x1$1) {
        Tuple2 tuple2;
        char ch;
        block3: {
            Tuple2<Character, Tuple2> tuple22;
            block2: {
                tuple22 = new Tuple2<Character, Tuple2>(BoxesRunTime.boxToCharacter(x0$1), x1$1);
                if (tuple22 == null) break block2;
                ch = tuple22._1$mcC$sp();
                tuple2 = tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError(tuple22);
        }
        BigInt bi = (BigInt)tuple2._1();
        BigInt k = (BigInt)tuple2._2();
        int alphaIndex = BoxesRunTime.unboxToInt(Predef$Ensuring$.MODULE$.ensuring$extension3(Predef$.MODULE$.Ensuring(BoxesRunTime.boxToInteger(MODULE$.toBase58(ch))), (JFunction1$mcZI$sp & scala.Serializable)x$4 -> x$4 != -1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Wrong char in Base58 string"));
        Tuple2<BigInt, BigInt> tuple23 = new Tuple2<BigInt, BigInt>(bi.$plus(package$.MODULE$.BigInt().apply(alphaIndex).$times(k)), k.$times(MODULE$.Base()));
        return tuple23;
    }

    private Base58$() {
        MODULE$ = this;
        this.Alphabet = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
        this.DecodeTable = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, 9, 10, 11, 12, 13, 14, 15, 16, -1, 17, 18, 19, 20, 21, -1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, -1, -1, -1, -1, -1, -1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, -1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        this.Base = package$.MODULE$.BigInt().apply(58);
    }
}

