/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519.java;

import org.whispersystems.curve25519.java.Sha512;
import org.whispersystems.curve25519.java.fe_1;
import org.whispersystems.curve25519.java.fe_add;
import org.whispersystems.curve25519.java.fe_frombytes;
import org.whispersystems.curve25519.java.fe_invert;
import org.whispersystems.curve25519.java.fe_mul;
import org.whispersystems.curve25519.java.fe_sub;
import org.whispersystems.curve25519.java.fe_tobytes;
import org.whispersystems.curve25519.java.ge_p3;
import org.whispersystems.curve25519.java.ge_p3_tobytes;
import org.whispersystems.curve25519.java.ge_scalarmult_base;
import org.whispersystems.curve25519.java.open;
import org.whispersystems.curve25519.java.sign_modified;

public class curve_sigs {
    public static void curve25519_keygen(byte[] curve25519_pubkey_out, byte[] curve25519_privkey_in) {
        ge_p3 ed = new ge_p3();
        int[] ed_y_plus_one = new int[10];
        int[] one_minus_ed_y = new int[10];
        int[] inv_one_minus_ed_y = new int[10];
        int[] mont_x = new int[10];
        ge_scalarmult_base.ge_scalarmult_base(ed, curve25519_privkey_in);
        fe_add.fe_add(ed_y_plus_one, ed.Y, ed.Z);
        fe_sub.fe_sub(one_minus_ed_y, ed.Z, ed.Y);
        fe_invert.fe_invert(inv_one_minus_ed_y, one_minus_ed_y);
        fe_mul.fe_mul(mont_x, ed_y_plus_one, inv_one_minus_ed_y);
        fe_tobytes.fe_tobytes(curve25519_pubkey_out, mont_x);
    }

    public static int curve25519_sign(Sha512 sha512provider, byte[] signature_out, byte[] curve25519_privkey, byte[] msg, int msg_len, byte[] random) {
        ge_p3 ed_pubkey_point = new ge_p3();
        byte[] ed_pubkey = new byte[32];
        byte[] sigbuf = new byte[msg_len + 128];
        byte sign_bit = 0;
        ge_scalarmult_base.ge_scalarmult_base(ed_pubkey_point, curve25519_privkey);
        ge_p3_tobytes.ge_p3_tobytes(ed_pubkey, ed_pubkey_point);
        sign_bit = (byte)(ed_pubkey[31] & 0x80);
        sign_modified.crypto_sign_modified(sha512provider, sigbuf, msg, msg_len, curve25519_privkey, ed_pubkey, random);
        System.arraycopy(sigbuf, 0, signature_out, 0, 64);
        signature_out[63] = (byte)(signature_out[63] & 0x7F);
        signature_out[63] = (byte)(signature_out[63] | sign_bit);
        return 0;
    }

    public static int curve25519_verify(Sha512 sha512provider, byte[] signature, byte[] curve25519_pubkey, byte[] msg, int msg_len) {
        int[] mont_x = new int[10];
        int[] mont_x_minus_one = new int[10];
        int[] mont_x_plus_one = new int[10];
        int[] inv_mont_x_plus_one = new int[10];
        int[] one = new int[10];
        int[] ed_y = new int[10];
        byte[] ed_pubkey = new byte[32];
        long some_retval = 0L;
        byte[] verifybuf = new byte[msg_len + 64];
        byte[] verifybuf2 = new byte[msg_len + 64];
        fe_frombytes.fe_frombytes(mont_x, curve25519_pubkey);
        fe_1.fe_1(one);
        fe_sub.fe_sub(mont_x_minus_one, mont_x, one);
        fe_add.fe_add(mont_x_plus_one, mont_x, one);
        fe_invert.fe_invert(inv_mont_x_plus_one, mont_x_plus_one);
        fe_mul.fe_mul(ed_y, mont_x_minus_one, inv_mont_x_plus_one);
        fe_tobytes.fe_tobytes(ed_pubkey, ed_y);
        ed_pubkey[31] = (byte)(ed_pubkey[31] & 0x7F);
        ed_pubkey[31] = (byte)(ed_pubkey[31] | signature[63] & 0x80);
        System.arraycopy(signature, 0, verifybuf, 0, 64);
        verifybuf[63] = (byte)(verifybuf[63] & 0x7F);
        System.arraycopy(msg, 0, verifybuf, 64, msg_len);
        return open.crypto_sign_open(sha512provider, verifybuf2, some_retval, verifybuf, 64 + msg_len, ed_pubkey);
    }
}

