/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.crypto;

import java.util.Arrays;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import org.bouncycastle.util.BigIntegers;
import scala.Array$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.encode.Base16$;
import sigmastate.interpreter.CryptoConstants$;
import sigmastate.serialization.GroupElementSerializer$;

public final class ErgoSignature$ {
    public static ErgoSignature$ MODULE$;

    static {
        new ErgoSignature$();
    }

    public byte[] sign(byte[] msg, BigInt sk) {
        BigInt y = this.genSecret();
        SecP256K1Point pk = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), sk.bigInteger());
        SecP256K1Point w = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), y.bigInteger());
        byte[] s = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.genCommitment(pk, w))).$plus$plus(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(msg)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        BigInt c = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray(this.hf(s)));
        BigInt z = sk.$times(c).$plus(y).$percent(BigInt$.MODULE$.javaBigInteger2bigInt(CryptoConstants$.MODULE$.groupOrder()));
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(BigIntegers.asUnsignedByteArray(24, c.bigInteger()))).$plus$plus(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(BigIntegers.asUnsignedByteArray(32, z.bigInteger()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
    }

    public boolean verify(byte[] msg, byte[] signature, SecP256K1Point pk) {
        byte[] cBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(signature)).take(24);
        BigInt c = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray(cBytes));
        BigInt z = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(signature)).takeRight(32)));
        SecP256K1Point a1 = CryptoConstants$.MODULE$.dlogGroup().exponentiate(CryptoConstants$.MODULE$.dlogGroup().generator(), z.bigInteger());
        SecP256K1Point a2 = CryptoConstants$.MODULE$.dlogGroup().exponentiate(pk, c.bigInteger().negate());
        SecP256K1Point w = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(a1, a2);
        byte[] s = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.genCommitment(pk, w))).$plus$plus(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(msg)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        return Arrays.equals(this.hf(s), cBytes);
    }

    /*
     * WARNING - void declaration
     */
    public BigInt genSecret() {
        void var2_1;
        BigInt y;
        while (BoxesRunTime.equalsNumObject(y = package$.MODULE$.BigInt().apply(BigIntegers.fromUnsignedByteArray(CryptoConstants$.MODULE$.secureRandomBytes(32))), BoxesRunTime.boxToInteger(0)) || y.$greater$eq(BigInt$.MODULE$.javaBigInteger2bigInt(CryptoConstants$.MODULE$.groupOrder()))) {
        }
        return var2_1;
    }

    private byte[] hf(byte[] x) {
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Blake2b256$.MODULE$.hash(x))).take(24);
    }

    private byte[] genCommitment(SecP256K1Point pk, SecP256K1Point w) {
        byte[] prefix = Base16$.MODULE$.decode("010027100108cd").get();
        byte[] postfix = Base16$.MODULE$.decode("73000021").get();
        byte[] pkBytes = GroupElementSerializer$.MODULE$.toBytes(pk);
        byte[] wBytes = GroupElementSerializer$.MODULE$.toBytes(w);
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(prefix)).$plus$plus(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(pkBytes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(postfix)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(wBytes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
    }

    private ErgoSignature$() {
        MODULE$ = this;
    }
}

