/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigInteger;
import java.util.Objects;
import org.ergoplatform.restapi.client.ProofOfUpcomingTransactions;

@Schema(description="Block candidate related data for external miner to perform work")
public class WorkMessage {
    @SerializedName(value="msg")
    private String msg = null;
    @SerializedName(value="b")
    private BigInteger b = null;
    @SerializedName(value="h")
    private Integer h = null;
    @SerializedName(value="pk")
    private String pk = null;
    @SerializedName(value="proof")
    private ProofOfUpcomingTransactions proof = null;

    public WorkMessage msg(String string) {
        this.msg = string;
        return this;
    }

    @Schema(example="0350e25cee8562697d55275c96bb01b34228f9bd68fd9933f2a25ff195526864f5", required=true, description="Base16-encoded block header bytes without PoW solution")
    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String string) {
        this.msg = string;
    }

    public WorkMessage b(BigInteger bigInteger) {
        this.b = bigInteger;
        return this;
    }

    @Schema(example="987654321", required=true, description="Work target value")
    public BigInteger getB() {
        return this.b;
    }

    public void setB(BigInteger bigInteger) {
        this.b = bigInteger;
    }

    public WorkMessage h(Integer n) {
        this.h = n;
        return this;
    }

    @Schema(example="987654321", required=true, description="Work target value")
    public Integer getH() {
        return this.h;
    }

    public void setH(Integer n) {
        this.h = n;
    }

    public WorkMessage pk(String string) {
        this.pk = string;
        return this;
    }

    @Schema(example="0350e25cee8562697d55275c96bb01b34228f9bd68fd9933f2a25ff195526864f5", required=true, description="Base16-encoded miner public key")
    public String getPk() {
        return this.pk;
    }

    public void setPk(String string) {
        this.pk = string;
    }

    public WorkMessage proof(ProofOfUpcomingTransactions proofOfUpcomingTransactions) {
        this.proof = proofOfUpcomingTransactions;
        return this;
    }

    @Schema(description="")
    public ProofOfUpcomingTransactions getProof() {
        return this.proof;
    }

    public void setProof(ProofOfUpcomingTransactions proofOfUpcomingTransactions) {
        this.proof = proofOfUpcomingTransactions;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WorkMessage workMessage = (WorkMessage)object;
        return Objects.equals(this.msg, workMessage.msg) && Objects.equals(this.b, workMessage.b) && Objects.equals(this.pk, workMessage.pk) && Objects.equals(this.proof, workMessage.proof);
    }

    public int hashCode() {
        return Objects.hash(this.msg, this.b, this.pk, this.proof);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class WorkMessage {\n");
        stringBuilder.append("    msg: ").append(this.toIndentedString(this.msg)).append("\n");
        stringBuilder.append("    b: ").append(this.toIndentedString(this.b)).append("\n");
        stringBuilder.append("    pk: ").append(this.toIndentedString(this.pk)).append("\n");
        stringBuilder.append("    proof: ").append(this.toIndentedString(this.proof)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

