/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.AdditionalRegisters1;
import org.ergoplatform.explorer.client.model.AssetInstanceInfo;

public class OutputInfo1 {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="txId")
    private String txId = null;
    @SerializedName(value="value")
    private Long value = null;
    @SerializedName(value="index")
    private Integer index = null;
    @SerializedName(value="creationHeight")
    private Integer creationHeight = null;
    @SerializedName(value="ergoTree")
    private String ergoTree = null;
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="assets")
    private List<AssetInstanceInfo> assets = null;
    @SerializedName(value="additionalRegisters")
    private AdditionalRegisters1 additionalRegisters = null;
    @SerializedName(value="spentTransactionId")
    private String spentTransactionId = null;
    @SerializedName(value="mainChain")
    private Boolean mainChain = null;

    public OutputInfo1 id(String string) {
        this.id = string;
        return this;
    }

    @Schema(required=true, description="Id of the box")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public OutputInfo1 txId(String string) {
        this.txId = string;
        return this;
    }

    @Schema(required=true, description="Id of the transaction that created the box")
    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String string) {
        this.txId = string;
    }

    public OutputInfo1 value(Long l) {
        this.value = l;
        return this;
    }

    @Schema(required=true, description="Value of the box in nanoERG")
    public Long getValue() {
        return this.value;
    }

    public void setValue(Long l) {
        this.value = l;
    }

    public OutputInfo1 index(Integer n) {
        this.index = n;
        return this;
    }

    @Schema(required=true, description="Index of the output in a transaction")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer n) {
        this.index = n;
    }

    public OutputInfo1 creationHeight(Integer n) {
        this.creationHeight = n;
        return this;
    }

    @Schema(required=true, description="Height at which the box was created")
    public Integer getCreationHeight() {
        return this.creationHeight;
    }

    public void setCreationHeight(Integer n) {
        this.creationHeight = n;
    }

    public OutputInfo1 ergoTree(String string) {
        this.ergoTree = string;
        return this;
    }

    @Schema(required=true, description="Serialized ergo tree")
    public String getErgoTree() {
        return this.ergoTree;
    }

    public void setErgoTree(String string) {
        this.ergoTree = string;
    }

    public OutputInfo1 address(String string) {
        this.address = string;
        return this;
    }

    @Schema(required=true, description="An address derived from ergo tree")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public OutputInfo1 assets(List<AssetInstanceInfo> list) {
        this.assets = list;
        return this;
    }

    public OutputInfo1 addAssetsItem(AssetInstanceInfo assetInstanceInfo) {
        if (this.assets == null) {
            this.assets = new ArrayList<AssetInstanceInfo>();
        }
        this.assets.add(assetInstanceInfo);
        return this;
    }

    @Schema(description="")
    public List<AssetInstanceInfo> getAssets() {
        return this.assets;
    }

    public void setAssets(List<AssetInstanceInfo> list) {
        this.assets = list;
    }

    public OutputInfo1 additionalRegisters(AdditionalRegisters1 additionalRegisters1) {
        this.additionalRegisters = additionalRegisters1;
        return this;
    }

    @Schema(required=true, description="")
    public AdditionalRegisters1 getAdditionalRegisters() {
        return this.additionalRegisters;
    }

    public void setAdditionalRegisters(AdditionalRegisters1 additionalRegisters1) {
        this.additionalRegisters = additionalRegisters1;
    }

    public OutputInfo1 spentTransactionId(String string) {
        this.spentTransactionId = string;
        return this;
    }

    @Schema(description="Transaction ID")
    public String getSpentTransactionId() {
        return this.spentTransactionId;
    }

    public void setSpentTransactionId(String string) {
        this.spentTransactionId = string;
    }

    public OutputInfo1 mainChain(Boolean bl) {
        this.mainChain = bl;
        return this;
    }

    @Schema(required=true, description="")
    public Boolean isMainChain() {
        return this.mainChain;
    }

    public void setMainChain(Boolean bl) {
        this.mainChain = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OutputInfo1 outputInfo1 = (OutputInfo1)object;
        return Objects.equals(this.id, outputInfo1.id) && Objects.equals(this.txId, outputInfo1.txId) && Objects.equals(this.value, outputInfo1.value) && Objects.equals(this.index, outputInfo1.index) && Objects.equals(this.creationHeight, outputInfo1.creationHeight) && Objects.equals(this.ergoTree, outputInfo1.ergoTree) && Objects.equals(this.address, outputInfo1.address) && Objects.equals(this.assets, outputInfo1.assets) && Objects.equals(this.additionalRegisters, outputInfo1.additionalRegisters) && Objects.equals(this.spentTransactionId, outputInfo1.spentTransactionId) && Objects.equals(this.mainChain, outputInfo1.mainChain);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.txId, this.value, this.index, this.creationHeight, this.ergoTree, this.address, this.assets, this.additionalRegisters, this.spentTransactionId, this.mainChain);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class OutputInfo1 {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    txId: ").append(this.toIndentedString(this.txId)).append("\n");
        stringBuilder.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        stringBuilder.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        stringBuilder.append("    creationHeight: ").append(this.toIndentedString(this.creationHeight)).append("\n");
        stringBuilder.append("    ergoTree: ").append(this.toIndentedString(this.ergoTree)).append("\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        stringBuilder.append("    additionalRegisters: ").append(this.toIndentedString(this.additionalRegisters)).append("\n");
        stringBuilder.append("    spentTransactionId: ").append(this.toIndentedString(this.spentTransactionId)).append("\n");
        stringBuilder.append("    mainChain: ").append(this.toIndentedString(this.mainChain)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

