"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A subscription filter for an attribute.
 */
class SubscriptionFilter {
    /**
     *
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     */
    static stringFilter(stringConditions) {
        var _b, _c;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sns_StringConditions(stringConditions);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.stringFilter);
            }
            throw error;
        }
        const conditions = new Array();
        if (stringConditions.whitelist && stringConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        if (stringConditions.blacklist && stringConditions.denylist) {
            throw new Error('`blacklist` is deprecated; please use `denylist` instead');
        }
        const allowlist = (_b = stringConditions.allowlist) !== null && _b !== void 0 ? _b : stringConditions.whitelist;
        const denylist = (_c = stringConditions.denylist) !== null && _c !== void 0 ? _c : stringConditions.blacklist;
        if (allowlist) {
            conditions.push(...allowlist);
        }
        if (denylist) {
            conditions.push({ 'anything-but': denylist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     */
    static numericFilter(numericConditions) {
        var _b;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sns_NumericConditions(numericConditions);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.numericFilter);
            }
            throw error;
        }
        const conditions = new Array();
        if (numericConditions.whitelist && numericConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        const allowlist = (_b = numericConditions.allowlist) !== null && _b !== void 0 ? _b : numericConditions.whitelist;
        if (allowlist) {
            conditions.push(...allowlist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan !== undefined) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo !== undefined) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan !== undefined) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo !== undefined) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
_a = JSII_RTTI_SYMBOL_1;
SubscriptionFilter[_a] = { fqn: "@aws-cdk/aws-sns.SubscriptionFilter", version: "1.154.0" };
//# sourceMappingURL=data:application/json;base64,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