# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['validator903', 'validator903.util']

package_data = \
{'': ['*']}

install_requires = \
['numpy==1.17.5',
 'openpyxl>=3.0.9,<4.0.0',
 'pandas==1.0.5',
 'quality-lac-data-ref-authorities>=2021.4',
 'quality-lac-data-ref-postcodes>=2021.8.1']

setup_kwargs = {
    'name': 'quality-lac-data-validator',
    'version': '0.2.0a5',
    'description': 'Shared module for validating the ruleset on the SSDA903 census using DfE rules.',
    'long_description': "# Quality LAC data beta: Python validator\n\n![Build & Test](https://github.com/SocialFinanceDigitalLabs/quality-lac-data-beta-validator/actions/workflows/run-tests.yml/badge.svg)\n[![PyPI version](https://badge.fury.io/py/quality-lac-data-validator.svg)](https://badge.fury.io/py/quality-lac-data-validator)\n[![Run on Repl.it](https://repl.it/badge/github/SocialFinanceDigitalLabs/quality-lac-data-beta-validator)](https://repl.it/github/SocialFinanceDigitalLabs/quality-lac-data-beta-validator)\n\n*We want to build a tool that improves the quality of data on Looked After Children so that Children’s Services Departments have all the information needed to enhance services.*\n\nWe believe that a tool that highlights and helps fixing data errors would be valuable for:\n\n1.   Reducing the time analysts, business support and social workers spend cleaning data\n2.   Enabling leadership to better use evidence in supporting Looked After Children\n\n## About this project\n\nThe aim of this project is to deliver a tool to relieve some of the pain-points\nof [reporting and quality][qlac-blog] in children's services data. This project\nfocuses in particular on data on looked after children (LAC) and the\n[SSDA903][dfe-903] return.\n\nThe project consists of a number of related pieces of work:\n\n* [Hosted Tool][qlac]\n* [React & Pyodie Front-End][qlac-front-end]\n* [Python Validator Engine & Rules][qlac-engine] [this repo]\n* [Local Authority Reference Data][qlac-ref-la]\n* [Postcode Reference Data][qlac-ref-pc]\n\nThe core parts consist of a [Python][python] validator engine and rules using\n[Pandas][pandas] with [Poetry][poetry] for dependency management. The is targeted\nto run either standalone, or in [pyodide][pyodide] in the browser for a zero-install\ndeployment with offline capabilities.\n\nIt provides methods of finding the validation errors defined by the DfE in 903 data.\nThe validator needs to be provided with a set of input files for the current year and,\noptionally, the previous year. These files are coerced into a common format and sent to\neach of the validator rules in turn. The validators report on rows not meeting the rules\nand a report is provided highlight errors for each row and which fields were included in\nthe checks.\n\n## Data pipeline\n\n* Loading of files\n* Identification of tables - currently matched on **exact** filename\n* Conversion of CSV to tabular format - **no type checking**\n* Enrichment of provided data with Postcode distances\n* Evalutation of rules\n* Report\n\n### Project Structure\n\nThese are the key files\n\n```\nproject\n├─── pyproject.toml           - Project details and dependencies\n├─── validator903\n│    ├─── config.py           - High-level configuration\n│    ├─── ingress.py          - Data ingress (handling CSV and XML files)\n│    ├─── types.py            - Classes used across the work\n│    ├─── validator.py        - The core validator process\n│    └─── validators.py       - All individual validator codes\n└─── tests                    - Unit tests\n```\n\nMost of the work from contributors will be in `validators.py` and the associates testing files under\ntests. Please do not submit a pull-request without a comprehensive test.\n\n### Development\n\nTo install the code and dependencies. Then from the main project directory run\n\n```\npoetry install\n```\n\n### Adding validators\n\nValidators are simple functions, usually called `validate_XXX()` which take no arguments and\nreturn a tuple of an `ErrorDefinition` and a test function. The test function itself takes\na single argument, the *datastore*, which is a [Mapping][py-mapping] (a dict-like) following the structure below.\n\nThe following is the expected structure for the input data that is given to each validator (the `dfs` object).\nYou should assume that not all of these keys are present and handle that appropriately.\n\nAny XML uploads are converted into CSV form to give the same inputs.\n\n```\n{\n    # This years data\n    'Header':   # header dataframe\n    'Episodes': # episodes dataframe\n    'Reviews':  # reviews dataframe\n    'UASC':     # UASC dataframe\n    'OC2':      # OC2 dataframe\n    'OC3':      # OC3 dataframe\n    'AD1':      # AD1 dataframe\n    'PlacedAdoption':  # Placed for adoption dataframe\n    'PrevPerm': # Previous permanence dataframe\n    'Missing':  # Missing dataframe\n    # Last years data\n    'Header_last':   # header dataframe\n    'Episodes_last': # episodes dataframe\n    'Reviews_last':  # reviews dataframe\n    'UASC_last':     # UASC dataframe\n    'OC2_last':      # OC2 dataframe\n    'OC3_last':      # OC3 dataframe\n    'AD1_last':      # AD1 dataframe\n    'PlacedAdoption_last':  # Placed for adoption dataframe\n    'PrevPerm_last': # Previous permanence dataframe\n    'Missing_last':  # Missing dataframe\n    # Metadata\n    'metadata': {\n        'collection_start': # A datetime with the collection start date (year/4/1)\n        'collection_end':   # A datetime with the collection end date (year + 1/4/1)\n        'postcodes':        # Postcodes dataframe, columns laua, oseast1m, osnrth1m, pcd\n        'localAuthority:    # The local authority code entered (long form, e.g. E07000026)\n        'collectionYear':   # The raw collection year string - unlikely to need this (e.g. '2019/20')\n    }\n}\n```\n\n## Releases\n\nTo build and release a new version, make sure all your unit tests pass.\n\nWe use [semantic versioning][semver], so update the project version in [pyproject.toml](./pyproject.toml) accordingly\nand commit, creating a PR. Once the release version is on GitHub, create a GitHub release naming the release with the \ncurrent release name, e.g. 1.0 and the tag with the release name prefixed with a v, i.e. v1.0. Alpha and beta releases \ncan be flagged by appending `-alpha.<number>` and `-beta.<number>`.\n\n\n[qlac-blog]: https://www.socialfinance.org.uk/blogs/better-data-children-care-building-common-approach\n[dfe-903]: https://www.gov.uk/guidance/children-looked-after-return-guide-to-submitting-data\n\n[python]: https://www.python.org/\n[pandas]: https://pandas.pydata.org/\n[poetry]: https://python-poetry.org/\n[pyodide]: https://pyodide.org/en/stable/\n[semver]: https://semver.org/\n\n[qlac]: https://sfdl.org.uk/quality-lac-data-beta/\n[qlac-front-end]: https://github.com/SocialFinanceDigitalLabs/quality-lac-data-beta\n[qlac-engine]: https://github.com/SocialFinanceDigitalLabs/quality-lac-data-beta-validator\n[qlac-ref-la]: https://github.com/SocialFinanceDigitalLabs/quality-lac-data-ref-authorities\n[qlac-ref-pc]: https://github.com/SocialFinanceDigitalLabs/quality-lac-data-ref-postcodes\n\n[py-mapping]: https://docs.python.org/3/library/collections.abc.html#collections.abc.Mapping\n",
    'author': 'Mark Waddoups',
    'author_email': 'mark.waddoups@socialfinance.org.uk',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/SocialFinanceDigitalLabs/quality-lac-data-beta-validator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
