<!--

#################################################
### THIS FILE WAS AUTOGENERATED! DO NOT EDIT! ###
#################################################
# file to edit: index.ipynb
# command to build the docs after a change: nbdev_build_docs

-->

# TCIA (The Cancer Imaging Archive) Download Client for Python

> This Python package uses the official TCIA REST API to enable downloads from www.cancerimagingarchive.net from within Python scripts and Jupyter Notebooks.


The documentation can be found at https://moritzschwyzer.github.io/tciaclient/. This PyPI/Conda package is based on source code of the TCIA-API-SDK https://github.com/TCIA-Community/TCIA-API-SDK.

## Install

`pip install tciaclient`

## How to use

Step 1: Import the `TCIAClient` from the `tciaclient.core` package.
<div class="codecell" markdown="1">
<div class="input_area" markdown="1">

```python
from tciaclient.core import TCIAClient
```

</div>

</div>

Step 2: Create an instance of the `TCIAClient`.
<div class="codecell" markdown="1">
<div class="input_area" markdown="1">

```python
tc = TCIAClient()
```

</div>

</div>

Step 3: Specify the collection you want to download (find the name on https://wiki.cancerimagingarchive.net/display/Public/Collections).
<div class="codecell" markdown="1">
<div class="input_area" markdown="1">

```python
collection_name = "NSCLC-Radiomics"
```

</div>

</div>

Step 4: Get the series information of the chosen collection. In this example, we specify that we only want series that are CT scans.
<div class="codecell" markdown="1">
<div class="input_area" markdown="1">

```python
series = tc.get_series(collection=collection_name, modality="CT")
```

</div>

</div>

Step 5: Download the dataset to the specified path.
<div class="codecell" markdown="1">
<div class="input_area" markdown="1">

```python
download_path = "./tcia-downloads"
for i, s in enumerate(series):
    print(i)
    tc.get_image(seriesInstanceUid = s["SeriesInstanceUID"],
        downloadPath = download_path, zipFileName = str(i).zfill(3)+"-"+collection_name+".zip")
```

</div>

</div>

## TCIA Data Usage Policies and Restrictions
Please https://wiki.cancerimagingarchive.net/display/Public/Data+Usage+Policies+and+Restrictions