# DeepCell-RetinaMask

[![Build Status](https://github.com/vanvalenlab/deepcell-retinamask/workflows/build/badge.svg)](https://github.com/vanvalenlab/deepcell-retinamask/actions)
[![Coverage Status](https://coveralls.io/repos/github/vanvalenlab/deepcell-retinamask/badge.svg?branch=master)](https://coveralls.io/github/vanvalenlab/deepcell-retinamask?branch=master)
[![Apache 2.0](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://github.com/vanvalenlab/deepcell-retinamask/blob/master/LICENSE)
[![PyPI version](https://badge.fury.io/py/DeepCell-RetinaMask.svg)](https://badge.fury.io/py/deepcell-retinamask)
[![Python Versions](https://img.shields.io/pypi/pyversions/deepcell-retinamask.svg)](https://pypi.org/project/deepcell-retinamask/)

`deepcell-retinamask` is a deep learning library for building RetinaNet and RetinaMask based object detection models with `tensorflow` and `deepcell-tf`.

This project was heavily influenced by [keras-retinanet](https://github.com/fizyr/keras-retinanet) and [keras-maskrcnn](https://github.com/fizyr/keras-maskrcnn).

## Install

`deepcell-retinamask` can be easily installed with pip:

```bash
$ pip install deepcell-retinamask
```

## Examples

For examples of how to train models with the `deepcell-retinamask` library, check out the following notebooks:

- [Training a RetinaNet Model](https://github.com/vanvalenlab/deepcell-retinamask/blob/master/notebooks/RetinaNet.ipynb)
- [Training a RetinaMask Model](https://github.com/vanvalenlab/deepcell-retinamask/blob/master/notebooks/RetinaMask.ipynb)
- [Training a PanOpticFPN Model](https://github.com/vanvalenlab/deepcell-retinamask/blob/master/notebooks/PanOpticFPN.ipynb)
