# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lk_utils', 'lk_utils.excel', 'lk_utils.nlp', 'lk_utils.nlp.resource.metadata']

package_data = \
{'': ['*'],
 'lk_utils.nlp': ['resource/*'],
 'lk_utils.nlp.resource.metadata': ['more/*']}

install_requires = \
['lk-logger>=5.1.0,<6.0.0']

extras_require = \
{'all': ['xlrd==1.2.0', 'xlsxwriter', 'pypinyin', 'pyyaml', 'toml'],
 'exl': ['xlrd==1.2.0', 'xlsxwriter'],
 'ext': ['pyyaml', 'toml'],
 'nlp': ['pypinyin']}

setup_kwargs = {
    'name': 'lk-utils',
    'version': '2.3.0',
    'description': 'LK Utils is a set of utility wrappers made for data processing.',
    'long_description': '# LK Utils\n\nlk-utils is a set of utility wrappers to make data processing more simple and fluent.\n\n# Install\n\n```shell\npip install lk-utils\n```\n\nthe default pip install doesn\'t include extra dependencies. to get extra support for excel or nlp processing, pip install this:\n\n```shell\npip install lk-utils  # to add lk-logger (required dependency)\npip install lk-utils[exl]  # to add lk-logger, xlrd, xlsxwriter\npip install lk-utils[nlp]  # to add lk-logger, pypinyin\npip install lk-utils[all]  # to add all of the above\n```\n\nlk-utils requires Python 3.8 or higher version.\n\n# Usage\n\n## subproc\n\n### new thread decorator\n\n```python\nfrom lk_utils.subproc import new_thread\n\n@new_thread(daemon=True, singleton=False)\ndef background_loop():\n    from time import sleep\n    i = 0\n    while i < 10:\n        i += 1\n        print(i)\n        sleep(1)\n\nx = background_loop()\nprint(type(x))  # -> threading.Thread\n```\n\n### run in new thread\n\n```python\nfrom lk_utils.subproc import run_new_thread\n\ndef background_loop():\n    from time import sleep\n    i = 0\n    while i < 10:\n        i += 1\n        print(i)\n        sleep(1)\n\nx = run_new_thread(background_loop, args=None, kwargs=None, daemon=True)\nprint(type(x))  # -> threading.Thread\n```\n\n### run cmd args\n\n```python\nfrom lk_utils.subproc import run_cmd_shell, run_cmd_args\nrun_cmd_shell(\'python -m pip list\')\nrun_cmd_args(\'python\', \'-m\', \'pip\', \'list\')\n```\n\n### mklink, mklinks\n\n```python\n"""\nexample structure:\n    |= from_dir\n       |= folder_xxx\n       |- file_xxx.txt\n    |= to_dir_1    # empty\n    |= to_dir_2    # not empty\n       |- ...\n"""\n\nfrom lk_utils.subproc import mklink, mklinks\nmklink(\'/from_dir\', \'/to_dir_1\')\nmklinks(\'/from_dir\', \'/to_dir_2\')\n\n"""\nresult:\n    |= from_dir\n       |= folder_xxx\n       |- file_xxx.txt\n    |= to_dir_1         # this is a symlink\n    |= to_dir_2\n       |- ...\n       |= folder_xxx    # this is a symlink\n       |- file_xxx.txt  # this is a symlink\n"""\n```\n\n## filesniff\n\n### get current dir, get relative path\n\n```python\nimport os\nfrom lk_utils import filesniff as fs\nprint(fs.currdir()\n      == os.path.dirname(__file__)).replace(\'\\\\\', \'/\'))  # -> True\nprint(fs.relpath(\'..\')\n      == os.path.dirname(fs.currdir()))  # -> True\n```\n\n### list files/dirs\n\n```python\nfrom lk_utils import filesniff as fs\n\nfor path, name in fs.find_files(\'.\'):  # this is an generator.\n    print(path, name)\n    #   the first element is the **abspath**, the second is path\'s\n    #   basename (<- os.path.basename(path))\n\nfor path in fs.find_file_paths(\'.\'):  # this is a list[str]\n    print(path)\n\nfor name in fs.find_file_names(\'.\'):  # this is a list[str]\n    print(name)\n\n# more:\n#   fs.findall_files\n#   fs.findall_file_paths\n#   fs.findall_file_names\n#\n#   fs.find_dirs\n#   fs.find_dir_paths\n#   fs.find_dir_names\n#\n#   fs.findall_dirs\n#   fs.findall_dir_paths\n#   fs.findall_dir_names\n```\n\n## read_and_write\n\n### loads and dumps\n\n```python\nfrom lk_utils import read_and_write as rw\n\ndata_r = rw.loads(file_i)\n#   it recognizes json, yaml, pkl as sturctured data. others are treated as\n#   plain text.\n\ndata_w = ...\nrw.dumps(data_w, file_o)\n#   it recognizes json, yaml, pkl as sturctured data. others are treated as\n#   plain text.\n```\n\n---\n\n<font color="red">below are marked as deprecated.</font>\n\n## excel\n\n### excel reader and writer\n\n```python\nfrom lk_utils import excel as exl\n\nreader = exl.ExcelReader(file_i)\n#   accepts \'.xls\' and \'.xlsx\' files.\n...  # TODO:CompleteExample\n\nwriter = exl.ExcelWriter(file_o)\n#   accepts only \'.xlsx\' files.\n...  # TODO:CompleteExample\nwriter.save()\n\n```\n\n## nlp\n\n*TODO*\n',
    'author': 'Likianta',
    'author_email': 'likianta@foxmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
