#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
from .algorithms import (
    LINEAR_SWAP_NETWORK,
    LinearSwapNetworkTrotterAlgorithm,
    LOW_RANK,
    LowRankTrotterAlgorithm,
    SplitOperatorTrotterAlgorithm,
    SplitOperatorTrotterStep,
    SymmetricSplitOperatorTrotterStep,
    ControlledAsymmetricSplitOperatorTrotterStep,
    AsymmetricSplitOperatorTrotterStep,
    ControlledSymmetricSplitOperatorTrotterStep,
    SPLIT_OPERATOR,
)

from .diagonal_coulomb_trotter_error import (
    diagonal_coulomb_potential_and_kinetic_terms_as_arrays,
    bit_mask_of_modes_acted_on_by_fermionic_terms,
    split_operator_trotter_error_operator_diagonal_two_body,
    fermionic_swap_trotter_error_operator_diagonal_two_body,
)

from .hubbard_trotter_error import \
    simulation_ordered_grouped_hubbard_terms_with_info

from .low_depth_trotter_error import (
    low_depth_second_order_trotter_error_operator,
    low_depth_second_order_trotter_error_bound,
    simulation_ordered_grouped_low_depth_terms_with_info,
    stagger_with_info,
)

from .simulate_trotter import simulate_trotter

from .trotter_algorithm import TrotterAlgorithm, TrotterStep

from .trotter_error import (
    error_bound,
    error_operator,
    trotter_steps_required,
)
